/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.ContentTransformer;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindLatestRevCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableHistoryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableMergeQueryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableMultiDiffCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableQueryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableSingleDiffCall;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.DiffResultType;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryListener;
import io.netty.channel.EventLoopGroup;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

final class CachingRepository
implements Repository {
    private static final CancellationException CANCELLATION_EXCEPTION = (CancellationException)Exceptions.clearTrace((Throwable)new CancellationException("watch cancelled by caller"));
    private final Repository repo;
    private final RepositoryCache cache;

    CachingRepository(Repository repo, RepositoryCache cache) {
        this.repo = Objects.requireNonNull(repo, "repo");
        this.cache = Objects.requireNonNull(cache, "cache");
    }

    @Override
    public org.eclipse.jgit.lib.Repository jGitRepository() {
        return this.repo.jGitRepository();
    }

    @Override
    public long creationTimeMillis() {
        return this.repo.creationTimeMillis();
    }

    @Override
    public Author author() {
        return this.repo.author();
    }

    @Override
    public <T> CompletableFuture<Entry<T>> getOrNull(Revision revision, Query<T> query) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        Revision normalizedRevision = this.normalizeNow(revision);
        if (query.type() == QueryType.IDENTITY || query.type() == QueryType.IDENTITY_TEXT || query.type() == QueryType.IDENTITY_JSON) {
            String path = query.path();
            CompletionStage future = this.find(revision, path, FindOptions.FIND_ONE_WITH_CONTENT).thenApply(findResult -> (Entry)findResult.get(path));
            return (CompletableFuture)Util.unsafeCast((Object)future);
        }
        CompletionStage future = this.cache.get(new CacheableQueryCall(this.repo, normalizedRevision, query)).handleAsync((result, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return result != CacheableQueryCall.EMPTY ? result : null;
        }, CachingRepository.executor());
        return (CompletableFuture)Util.unsafeCast((Object)future);
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(options, "options");
        Revision normalizedRevision = this.normalizeNow(revision);
        return this.cache.get(new CacheableFindCall(this.repo, normalizedRevision, pathPattern, options)).handleAsync((unused, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return unused;
        }, CachingRepository.executor());
    }

    @Override
    public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern, int maxCommits) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (maxCommits <= 0) {
            throw new IllegalArgumentException("maxCommits: " + maxCommits + " (expected: > 0)");
        }
        RevisionRange range = this.normalizeNow(from, to);
        int actualMaxCommits = Math.min(maxCommits, Math.abs(range.from().major() - range.to().major()) + 1);
        return this.cache.get(new CacheableHistoryCall(this.repo, range.from(), range.to(), pathPattern, actualMaxCommits)).handleAsync((unused, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return unused;
        }, CachingRepository.executor());
    }

    @Override
    public CompletableFuture<Change<?>> diff(Revision from, Revision to, Query<?> query) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(query, "query");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        return this.cache.get(new CacheableSingleDiffCall(this.repo, range.from(), range.to(), query)).handleAsync((unused, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return unused;
        }, CachingRepository.executor());
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern, DiffResultType diffResultType) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(diffResultType, "diffResultType");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        return this.cache.get(new CacheableMultiDiffCall(this.repo, range.from(), range.to(), pathPattern, diffResultType)).handleAsync((unused, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return unused;
        }, CachingRepository.executor());
    }

    @Override
    public CompletableFuture<Revision> findLatestRevision(Revision lastKnownRevision, String pathPattern, boolean errorOnEntryNotFound) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        RevisionRange range = this.normalizeNow(lastKnownRevision, Revision.HEAD);
        if (range.from().equals((Object)range.to())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.cache.get(new CacheableFindLatestRevCall(this.repo, range.from(), range.to(), pathPattern, errorOnEntryNotFound)).handleAsync((result, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            if (result == CacheableFindLatestRevCall.ENTRY_NOT_FOUND) {
                throw new EntryNotFoundException(range.from(), pathPattern);
            }
            if (result == CacheableFindLatestRevCall.EMPTY) {
                return null;
            }
            return result;
        }, CachingRepository.executor());
    }

    @Override
    public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern, boolean errorOnEntryNotFound) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        CompletableFuture<Revision> latestRevFuture = this.findLatestRevision(lastKnownRevision, pathPattern, errorOnEntryNotFound);
        if (latestRevFuture.isCompletedExceptionally() || latestRevFuture.getNow(null) != null) {
            return latestRevFuture;
        }
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        latestRevFuture.whenComplete((latestRevision, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
                return;
            }
            if (latestRevision != null) {
                future.complete((Revision)latestRevision);
                return;
            }
            CompletableFuture<Revision> watchFuture = this.repo.watch(lastKnownRevision, pathPattern, errorOnEntryNotFound);
            watchFuture.whenComplete((watchResult, watchCause) -> {
                if (watchCause == null) {
                    future.complete((Revision)watchResult);
                } else {
                    future.completeExceptionally((Throwable)watchCause);
                }
            });
            future.whenComplete((unused1, unused2) -> watchFuture.completeExceptionally(CANCELLATION_EXCEPTION));
        });
        return future;
    }

    @Override
    public <T> CompletableFuture<MergedEntry<T>> mergeFiles(Revision revision, MergeQuery<T> query) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        Revision normalizedRevision = this.normalizeNow(revision);
        CacheableMergeQueryCall key = new CacheableMergeQueryCall(this.repo, normalizedRevision, query);
        CompletableFuture value = this.cache.getIfPresent(key);
        if (value != null) {
            return (CompletableFuture)Util.unsafeCast((Object)value.handleAsync((unused, cause) -> {
                HttpApiUtil.throwUnsafelyIfNonNull(cause);
                return unused;
            }, CachingRepository.executor()));
        }
        return Repository.super.mergeFiles(normalizedRevision, query).thenApply(mergedEntry -> {
            key.computedValue((MergedEntry<?>)mergedEntry);
            this.cache.get(key);
            return mergedEntry;
        });
    }

    @Override
    public void addListener(RepositoryListener listener) {
        this.repo.addListener(listener);
    }

    @Override
    public void removeListener(RepositoryListener listener) {
        this.repo.removeListener(listener);
    }

    private static Executor executor() {
        return (Executor)RequestContext.mapCurrent(RequestContext::eventLoop, () -> ((EventLoopGroup)CommonPools.workerGroup()).next());
    }

    @Override
    public Project parent() {
        return this.repo.parent();
    }

    @Override
    public String name() {
        return this.repo.name();
    }

    @Override
    public Revision normalizeNow(Revision revision) {
        return this.repo.normalizeNow(revision);
    }

    @Override
    public RevisionRange normalizeNow(Revision from, Revision to) {
        return this.repo.normalizeNow(from, to);
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        return this.repo.previewDiff(baseRevision, changes);
    }

    @Override
    public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes, boolean normalizing) {
        return this.repo.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, changes, normalizing);
    }

    @Override
    public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, ContentTransformer<?> transformer) {
        return this.repo.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, transformer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("repo", (Object)this.repo).toString();
    }
}

