/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.centraldogma.server.internal.mirror.CentralDogmaMirror;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryUri;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorContext;
import com.linecorp.centraldogma.server.mirror.MirrorProvider;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CentralDogmaMirrorProvider
implements MirrorProvider {
    private static final Pattern DOGMA_PATH_PATTERN = Pattern.compile("^/([^/]+)/([^/]+)\\.dogma$");

    @Override
    public Mirror newMirror(MirrorContext context) {
        Objects.requireNonNull(context, "context");
        URI remoteUri = context.remoteUri();
        String scheme = remoteUri.getScheme();
        if (scheme == null) {
            return null;
        }
        if (!"dogma".equals(scheme)) {
            return null;
        }
        RepositoryUri repositoryUri = RepositoryUri.parse(remoteUri, "dogma");
        Matcher pathMatcher = DOGMA_PATH_PATTERN.matcher(repositoryUri.uri().getPath());
        if (!pathMatcher.find()) {
            throw new IllegalArgumentException("cannot determine project name and repository name: " + remoteUri + " (expected: dogma://<host>[:<port>]/<project>/<repository>.dogma[<remotePath>])");
        }
        String remoteProject = pathMatcher.group(1);
        String remoteRepo = pathMatcher.group(2);
        String remotePath = repositoryUri.path();
        return new CentralDogmaMirror(context.id(), context.enabled(), context.schedule(), context.direction(), context.credential(), context.localRepo(), context.localPath(), repositoryUri.uri(), remoteProject, remoteRepo, remotePath, context.gitignore());
    }
}

