/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.TooManyRequestsException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.Joiner;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMultimap;
import com.linecorp.centraldogma.internal.shaded.guava.escape.Escaper;
import com.linecorp.centraldogma.internal.shaded.guava.escape.Escapers;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.MoreExecutors;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.Uninterruptibles;
import com.linecorp.centraldogma.server.QuotaConfig;
import com.linecorp.centraldogma.server.ZooKeeperReplicationConfig;
import com.linecorp.centraldogma.server.ZooKeeperServerConfig;
import com.linecorp.centraldogma.server.command.AbstractCommandExecutor;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.ForcePushCommand;
import com.linecorp.centraldogma.server.command.NormalizableCommit;
import com.linecorp.centraldogma.server.command.NormalizingPushCommand;
import com.linecorp.centraldogma.server.command.PushAsIsCommand;
import com.linecorp.centraldogma.server.command.RemoveRepositoryCommand;
import com.linecorp.centraldogma.server.command.UpdateServerStatusCommand;
import com.linecorp.centraldogma.server.internal.replication.EmbeddedZooKeeper;
import com.linecorp.centraldogma.server.internal.replication.ReplicationException;
import com.linecorp.centraldogma.server.internal.replication.ReplicationLog;
import com.linecorp.centraldogma.server.internal.replication.SettableSharedCount;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.curator.framework.recipes.shared.SharedCountReader;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.RetryForever;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.auth.DigestLoginModule;
import org.apache.zookeeper.server.auth.SASLAuthenticationProvider;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZooKeeperCommandExecutor
extends AbstractCommandExecutor
implements PathChildrenCacheListener {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperCommandExecutor.class);
    private static final Escaper jaasValueEscaper = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
    private static final Joiner colonJoiner = Joiner.on((char)':');
    private static final String PATH_PREFIX = "/dogma";
    private static final int MAX_BYTES = 1047552;
    private static final String LOG_PATH = "logs";
    private static final String LOG_BLOCK_PATH = "log_blocks";
    private static final String LOCK_PATH = "lock";
    private static final String QUOTA_PATH = "quota";
    private static final String LEADER_PATH = "leader";
    private static final RetryPolicy RETRY_POLICY_ALWAYS = new RetryForever(500);
    private static final RetryPolicy RETRY_POLICY_NEVER = (retryCount, elapsedTimeMs, sleeper) -> false;
    private static final QuotaConfig UNLIMITED_QUOTA = new QuotaConfig(Integer.MAX_VALUE, 1);
    private static final Map.Entry<InterProcessSemaphoreV2, SettableSharedCount> UNLIMITED_SEMAPHORE = new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null);
    private final ConcurrentMap<String, InterProcessMutex> mutexMap = new ConcurrentHashMap<String, InterProcessMutex>();
    @VisibleForTesting
    final ConcurrentMap<String, Map.Entry<InterProcessSemaphoreV2, SettableSharedCount>> semaphoreMap = new ConcurrentHashMap<String, Map.Entry<InterProcessSemaphoreV2, SettableSharedCount>>();
    @VisibleForTesting
    final Cache<String, QuotaConfig> writeQuotaCache = Caffeine.newBuilder().maximumSize(2000L).build();
    private final ZooKeeperReplicationConfig cfg;
    private final File revisionFile;
    private final File zkConfFile;
    private final File zkDataDir;
    private final File zkLogDir;
    private final CommandExecutor delegate;
    private final MeterRegistry meterRegistry;
    @Nullable
    private final QuotaConfig writeQuota;
    @Nullable
    private final String zone;
    private MetadataService metadataService;
    private long lockTimeoutNanos = TimeUnit.MINUTES.toNanos(1L);
    private volatile EmbeddedZooKeeper quorumPeer;
    private volatile CuratorFramework curator;
    private volatile RetryPolicy retryPolicy = RETRY_POLICY_NEVER;
    private volatile ExecutorService executor;
    private volatile ExecutorService logWatcherExecutor;
    private volatile PathChildrenCache logWatcher;
    private volatile OldLogRemover oldLogRemover;
    private volatile ExecutorService leaderSelectorExecutor;
    private volatile LeaderSelector leaderSelector;
    @Nullable
    private volatile ZoneLeaderPluginsRunner zonePluginsRunner;
    @Nullable
    private volatile ExecutorService zoneLeaderSelectorExecutor;
    @Nullable
    private volatile LeaderSelector zoneLeaderSelector;
    private volatile ScheduledExecutorService quotaExecutor;
    private volatile boolean createdParentNodes;
    private volatile boolean canReplicate;
    private volatile ListenerInfo listenerInfo;

    public ZooKeeperCommandExecutor(ZooKeeperReplicationConfig cfg, File dataDir, CommandExecutor delegate, MeterRegistry meterRegistry, ProjectManager projectManager, @Nullable QuotaConfig writeQuota, @Nullable String zone, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership, @Nullable Consumer<CommandExecutor> onTakeZoneLeadership, @Nullable Consumer<CommandExecutor> onReleaseZoneLeadership) {
        super(onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
        this.cfg = Objects.requireNonNull(cfg, "cfg");
        Objects.requireNonNull(dataDir, "dataDir");
        this.revisionFile = new File(dataDir.getAbsolutePath() + File.separatorChar + "last_revision");
        this.zkConfFile = new File(dataDir.getAbsolutePath() + File.separatorChar + "_zookeeper" + File.separatorChar + "config.properties");
        this.zkDataDir = new File(dataDir.getAbsolutePath() + File.separatorChar + "_zookeeper" + File.separatorChar + "data");
        this.zkLogDir = new File(dataDir.getAbsolutePath() + File.separatorChar + "_zookeeper" + File.separatorChar + "log");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.writeQuota = writeQuota;
        this.metadataService = new MetadataService(projectManager, this);
        this.zone = zone;
        Gauge.builder((String)"replica.id", (Object)this, self -> this.replicaId()).register(meterRegistry);
        if (cfg.serverConfig().groupId() != null) {
            Gauge.builder((String)"replica.groupId", (Object)this, self -> self.cfg.serverConfig().groupId().intValue()).register(meterRegistry);
        }
        Gauge.builder((String)"replica.read.only", (Object)this, self -> self.isWritable() ? 0.0 : 1.0).register(meterRegistry);
        Gauge.builder((String)"replica.replicating", (Object)this, self -> self.isStarted() ? 1.0 : 0.0).register(meterRegistry);
        Gauge.builder((String)"replica.has.leadership", (Object)this, self -> {
            OldLogRemover remover = self.oldLogRemover;
            return remover != null && remover.hasLeadership ? 1.0 : 0.0;
        }).register(meterRegistry);
        if (onTakeZoneLeadership != null) {
            Gauge.builder((String)"replica.has.zone.leadership", (Object)this, self -> {
                ZoneLeaderPluginsRunner zoneRunner = self.zonePluginsRunner;
                return zoneRunner != null && zoneRunner.hasLeadership ? 1.0 : 0.0;
            }).tag("zone", zone).register(meterRegistry);
        }
        Gauge.builder((String)"replica.last.replayed.revision", (Object)this, self -> {
            ListenerInfo info = self.listenerInfo;
            if (info == null) {
                return 0.0;
            }
            return info.lastReplayedRevision;
        }).register(meterRegistry);
    }

    @Override
    public int replicaId() {
        return this.cfg.serverId();
    }

    @Override
    protected void doStart(@Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership, @Nullable Runnable onTakeZoneLeadership, @Nullable Runnable onReleaseZoneLeadership) throws Exception {
        try {
            try {
                long lastReplayedRevision = this.getLastReplayedRevision();
                this.listenerInfo = new ListenerInfo(lastReplayedRevision, onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
            }
            catch (Exception e) {
                throw new ReplicationException("failed to read " + this.revisionFile, e);
            }
            this.quorumPeer = this.startZooKeeper();
            this.retryPolicy = RETRY_POLICY_ALWAYS;
            this.curator = CuratorFrameworkFactory.newClient((String)("127.0.0.1:" + this.quorumPeer.getClientPort()), (int)this.cfg.timeoutMillis(), (int)this.cfg.timeoutMillis(), (retryCount, elapsedTimeMs, sleeper) -> this.retryPolicy.allowRetry(retryCount, elapsedTimeMs, sleeper));
            this.curator.start();
            this.logWatcherExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("zookeeper-log-watcher", true)), (String)"zkLogWatcher", (Tag[])new Tag[0]);
            this.logWatcher = new PathChildrenCache(this.curator, ZooKeeperCommandExecutor.absolutePath(LOG_PATH), true, false, this.logWatcherExecutor);
            this.logWatcher.getListenable().addListener((Object)this, MoreExecutors.directExecutor());
            this.logWatcher.start();
            this.oldLogRemover = new OldLogRemover();
            this.leaderSelectorExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("zookeeper-leader-selector", true)), (String)"zkLeaderSelector", (Tag[])new Tag[0]);
            this.leaderSelector = new LeaderSelector(this.curator, ZooKeeperCommandExecutor.absolutePath(LEADER_PATH), this.leaderSelectorExecutor, (LeaderSelectorListener)this.oldLogRemover);
            this.leaderSelector.start();
            if (onTakeZoneLeadership != null) {
                this.zonePluginsRunner = new ZoneLeaderPluginsRunner();
                this.zoneLeaderSelectorExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("zookeeper-zone-leader-selector", true)), (String)"zkZoneLeaderSelector", (Tag[])new Tag[0]);
                assert (this.zone != null);
                this.zoneLeaderSelector = new LeaderSelector(this.curator, ZooKeeperCommandExecutor.absolutePath(LEADER_PATH, this.zone), this.zoneLeaderSelectorExecutor, (LeaderSelectorListener)this.zonePluginsRunner);
                this.zoneLeaderSelector.start();
            }
            this.delegate.start().get();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(this.cfg.numWorkers(), this.cfg.numWorkers(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("zookeeper-command-executor", true));
            executor.allowCoreThreadTimeOut(true);
            this.executor = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)executor, (String)"zkCommandExecutor", (Tag[])new Tag[0]);
            this.quotaExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("zookeeper-quota-executor", true)), (String)"quotaExecutor", (Tag[])new Tag[0]);
            this.canReplicate = true;
        }
        catch (ReplicationException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReplicationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedZooKeeper startZooKeeper() throws Exception {
        logger.info("Starting the ZooKeeper peer ({}) ..", (Object)this.cfg.serverId());
        EmbeddedZooKeeper peer = null;
        boolean success = false;
        try {
            QuorumPeer.ServerState serverState;
            Properties zkProps = new Properties();
            this.copyZkProperty(zkProps, "initLimit", "5");
            this.copyZkProperty(zkProps, "syncLimit", "10");
            this.copyZkProperty(zkProps, "tickTime", "3000");
            this.copyZkProperty(zkProps, "syncEnabled", "true");
            this.copyZkProperty(zkProps, "autopurge.snapRetainCount", "3");
            this.copyZkProperty(zkProps, "autopurge.purgeInterval", "1");
            this.copyZkProperty(zkProps, "quorumListenOnAllIPs", "false");
            System.setProperty("zookeeper.fsync.warningthresholdms", this.cfg.additionalProperties().getOrDefault("fsync.warningthresholdms", "1000"));
            zkProps.setProperty("dataDir", this.zkDataDir.getPath());
            zkProps.setProperty("dataLogDir", this.zkLogDir.getPath());
            this.zkDataDir.mkdirs();
            this.zkLogDir.mkdirs();
            try (FileOutputStream out = new FileOutputStream(new File(this.zkDataDir, "myid"));){
                out.write((this.cfg.serverId() + "\n").getBytes(StandardCharsets.US_ASCII));
            }
            File jaasConfFile = new File(this.zkDataDir, "jaas.conf");
            try (FileOutputStream out = new FileOutputStream(jaasConfFile);){
                StringBuilder buf = new StringBuilder();
                String newline = System.lineSeparator();
                String embeddedZooKeeper = jaasValueEscaper.escape(this.cfg.secret());
                ImmutableList.of((Object)"Server", (Object)"QuorumServer").forEach(name -> {
                    buf.append((String)name).append(" {").append(newline);
                    buf.append(DigestLoginModule.class.getName()).append(" required").append(newline);
                    buf.append("user_super=\"").append(escapedSecret).append("\";").append(newline);
                    buf.append("};").append(newline);
                });
                ImmutableList.of((Object)"Client", (Object)"QuorumLearner").forEach(name -> {
                    buf.append((String)name).append(" {").append(newline);
                    buf.append(DigestLoginModule.class.getName()).append(" required").append(newline);
                    buf.append("username=\"super\"").append(newline);
                    buf.append("password=\"").append(escapedSecret).append("\";").append(newline);
                    buf.append("};").append(newline);
                });
                out.write(buf.toString().getBytes());
            }
            System.setProperty("java.security.auth.login.config", jaasConfFile.getAbsolutePath());
            System.setProperty("zookeeper.authProvider.1", SASLAuthenticationProvider.class.getName());
            zkProps.setProperty("clientPort", String.valueOf(this.cfg.serverConfig().clientPort()));
            Map<Integer, ZooKeeperServerConfig> servers = this.cfg.servers();
            boolean hasGroupId = false;
            for (Map.Entry entry : servers.entrySet()) {
                ZooKeeperServerConfig serverConfig2 = (ZooKeeperServerConfig)entry.getValue();
                zkProps.setProperty("server." + entry.getKey(), serverConfig2.host() + ':' + serverConfig2.quorumPort() + ':' + serverConfig2.electionPort() + ":participant");
                if (hasGroupId || serverConfig2.groupId() == null) continue;
                hasGroupId = true;
            }
            if (hasGroupId) {
                boolean bl;
                ImmutableMultimap.Builder groupBuilder = ImmutableMultimap.builder();
                boolean bl2 = true;
                for (Map.Entry entry : servers.entrySet()) {
                    Integer groupId2 = ((ZooKeeperServerConfig)entry.getValue()).groupId();
                    if (groupId2 == null) {
                        bl = false;
                        List noGroupIds = (List)servers.values().stream().filter(serverConfig -> serverConfig.groupId() == null).collect(ImmutableList.toImmutableList());
                        logger.warn("Hierarchical quorums are disabled. 'groupId' are missing in {}", (Object)noGroupIds);
                        break;
                    }
                    groupBuilder.put((Object)groupId2, (Object)((Integer)entry.getKey()));
                }
                if (bl) {
                    groupBuilder.build().asMap().forEach((groupId, serverIds) -> zkProps.setProperty("group." + groupId, colonJoiner.join((Iterable)serverIds)));
                    servers.forEach((serverId, serverConfig) -> zkProps.setProperty("weight." + serverId, String.valueOf(serverConfig.weight())));
                }
            }
            zkProps.setProperty("admin.enableServer", "false");
            this.zkConfFile.getParentFile().mkdirs();
            try (FileOutputStream out = new FileOutputStream(this.zkConfFile);){
                zkProps.store(out, null);
            }
            QuorumPeerConfig zkCfg = new QuorumPeerConfig();
            zkCfg.parse(this.zkConfFile.getPath());
            peer = new EmbeddedZooKeeper(zkCfg, this.meterRegistry);
            peer.start();
            while ((serverState = peer.getPeerState()) != QuorumPeer.ServerState.FOLLOWING && serverState != QuorumPeer.ServerState.LEADING) {
                if (this.isStopping()) {
                    throw new InterruptedException("Stop requested before joining the cluster");
                }
                logger.info("Waiting for the ZooKeeper peer ({}) to join the cluster ..", (Object)peer.getId());
                Thread.sleep(1000L);
            }
            if (peer.getId() == peer.getCurrentVote().getId()) {
                logger.info("The ZooKeeper peer ({}) has joined the cluster as a leader.", (Object)peer.getId());
            } else {
                logger.info("The ZooKeeper peer ({}) has joined the cluster, following {}.", (Object)peer.getId(), (Object)peer.getCurrentVote().getId());
            }
            success = true;
            EmbeddedZooKeeper embeddedZooKeeper = peer;
            return embeddedZooKeeper;
        }
        finally {
            if (!success && peer != null) {
                try {
                    peer.shutdown();
                }
                catch (Exception e) {
                    logger.warn("Failed to shutdown the failed ZooKeeper peer: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private void copyZkProperty(Properties zkProps, String key, String defaultValue) {
        zkProps.setProperty(key, this.cfg.additionalProperties().getOrDefault(key, defaultValue));
    }

    private void stopLater() {
        ForkJoinPool.commonPool().execute(this::stop);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void doStop(@Nullable Runnable onReleaseLeadership, @Nullable Runnable onReleaseZoneLeadership) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean shutdown(@Nullable ExecutorService executor) {
        if (executor == null) {
            return false;
        }
        boolean interrupted = false;
        while (!executor.isTerminated()) {
            executor.shutdown();
            try {
                executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        return interrupted;
    }

    private long getLastReplayedRevision() throws Exception {
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.revisionFile);
        }
        catch (FileNotFoundException ignored) {
            return -1L;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fis));){
            String l = br.readLine();
            if (l == null) {
                long l2 = -1L;
                return l2;
            }
            long l3 = Long.parseLong(l.trim());
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastReplayedRevision(long lastReplayedRevision) throws Exception {
        boolean success = false;
        try (FileOutputStream fos = new FileOutputStream(this.revisionFile);){
            fos.write(String.valueOf(lastReplayedRevision).getBytes(StandardCharsets.UTF_8));
            success = true;
        }
        finally {
            if (success) {
                logger.info("Updated lastReplayedRevision to: {}", (Object)lastReplayedRevision);
            } else {
                logger.error("Failed to update lastReplayedRevision to: {}", (Object)lastReplayedRevision);
            }
        }
    }

    private synchronized void replayLogs(long targetRevision) {
        ListenerInfo info = this.listenerInfo;
        if (info == null) {
            return;
        }
        if (targetRevision <= info.lastReplayedRevision) {
            return;
        }
        long nextRevision = info.lastReplayedRevision + 1L;
        while (this.canReplicate) {
            ReplicationLog<?> l = null;
            try {
                Optional<ReplicationLog<?>> log = this.loadLog(nextRevision, true);
                Command<?> command = null;
                if (log.isPresent()) {
                    Object actualResult;
                    l = log.get();
                    command = l.command();
                    Object expectedResult = l.result();
                    if (!Objects.equals(expectedResult, actualResult = this.delegate.execute(command).get())) {
                        throw new ReplicationException("mismatching replay result at revision " + nextRevision + ": " + actualResult + " (expected: " + expectedResult + ", command: " + command + ')');
                    }
                    if (command instanceof RemoveRepositoryCommand) {
                        this.clearWriteQuota((RemoveRepositoryCommand)command);
                    }
                }
                this.updateLastReplayedRevision(nextRevision);
                info.lastReplayedRevision = nextRevision;
                if (command instanceof UpdateServerStatusCommand) {
                    this.updateZkCommandStatusLater((UpdateServerStatusCommand)command);
                }
                if (nextRevision == targetRevision) break;
                ++nextRevision;
            }
            catch (Throwable t) {
                if (l != null) {
                    logger.error("Failed to replay a log at revision {}; entering read-only mode. replay log: {}", new Object[]{nextRevision, l, t});
                } else {
                    logger.error("Failed to replay a log at revision {}; entering read-only mode.", (Object)nextRevision, (Object)t);
                }
                this.stopLater();
                if (t instanceof ReplicationException) {
                    throw (ReplicationException)t;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("failed to replay a log at revision " + nextRevision);
                if (l != null) {
                    sb.append(". replay log: ").append(l);
                }
                throw new ReplicationException(sb.toString(), t);
            }
        }
    }

    private void updateZkCommandStatusLater(UpdateServerStatusCommand command) {
        this.canReplicate = command.serverStatus().replicating();
        if (!this.canReplicate) {
            ForkJoinPool.commonPool().execute(() -> this.statusManager().updateStatus(command));
        } else {
            this.statusManager().updateStatus(command);
        }
    }

    public void childEvent(CuratorFramework unused, PathChildrenCacheEvent event) throws Exception {
        if (event.getType() != PathChildrenCacheEvent.Type.CHILD_ADDED) {
            return;
        }
        long lastKnownRevision = ZooKeeperCommandExecutor.revisionFromPath(event.getData().getPath());
        try {
            this.replayLogs(lastKnownRevision);
        }
        catch (ReplicationException ignored) {
            return;
        }
        this.oldLogRemover.touch();
    }

    private SafeCloseable safeLock(Command<?> command) {
        long lockTimeoutNanos = this.lockTimeoutNanos;
        String executionPath = command.executionPath();
        InterProcessMutex mtx = this.mutexMap.computeIfAbsent(executionPath, k -> new InterProcessMutex(this.curator, ZooKeeperCommandExecutor.absolutePath(LOCK_PATH, k)));
        WriteLock writeLock = null;
        boolean lockAcquired = false;
        boolean success = false;
        Throwable cause = null;
        try {
            long remainingTimeNanos = lockTimeoutNanos;
            long deadlineNanos = System.nanoTime() + remainingTimeNanos;
            while (true) {
                try {
                    if (mtx.acquire(remainingTimeNanos, TimeUnit.NANOSECONDS)) {
                        lockAcquired = true;
                        break;
                    }
                }
                catch (NullPointerException e) {
                    logger.warn("Unexpected NPE from Curator while acquiring a lock for {} (command: {}):", new Object[]{executionPath, command, e});
                }
                long sleepTimeNanos = TimeUnit.MILLISECONDS.toNanos(500L);
                remainingTimeNanos = deadlineNanos - System.nanoTime();
                if (remainingTimeNanos <= sleepTimeNanos) break;
                Uninterruptibles.sleepUninterruptibly((long)sleepTimeNanos, (TimeUnit)TimeUnit.NANOSECONDS);
                remainingTimeNanos -= sleepTimeNanos;
            }
            if (lockAcquired) {
                if (command instanceof NormalizingPushCommand) {
                    writeLock = this.acquireWriteLock((NormalizingPushCommand)command);
                } else if (command instanceof RemoveRepositoryCommand) {
                    this.clearWriteQuota((RemoveRepositoryCommand)command);
                }
                success = true;
            }
        }
        catch (Throwable e) {
            cause = e;
        }
        if (!success) {
            if (cause != null) {
                logger.error("Failed to acquire a lock for {} (command: {}); entering read-only mode", new Object[]{executionPath, command, cause});
                this.stopLater();
                throw new ReplicationException("failed to acquire a lock for " + executionPath, cause);
            }
            logger.error("Failed to acquire a lock for {} in time (command: {}); entering read-only mode", (Object)executionPath, command);
            this.stopLater();
            throw new ReplicationException("failed to acquire a lock for " + executionPath + " in time");
        }
        if (writeLock != null) {
            this.scheduleWriteLockRelease(writeLock, mtx, executionPath);
        }
        return () -> ZooKeeperCommandExecutor.safeRelease(mtx);
    }

    private void clearWriteQuota(RemoveRepositoryCommand command) {
        String cacheKey = ZooKeeperCommandExecutor.rateLimiterKey(command.projectName(), command.repositoryName());
        this.semaphoreMap.remove(cacheKey);
        this.writeQuotaCache.invalidate((Object)cacheKey);
    }

    private static void safeRelease(InterProcessMutex mtx) {
        try {
            mtx.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    private WriteLock acquireWriteLock(NormalizingPushCommand command) throws Exception {
        if (command.projectName().equals("dogma") || command.repositoryName().equals("dogma")) {
            return null;
        }
        QuotaConfig writeQuota = (QuotaConfig)this.writeQuotaCache.getIfPresent((Object)command.executionPath());
        if (writeQuota == UNLIMITED_QUOTA) {
            return null;
        }
        if (writeQuota == null) {
            RepositoryMetadata meta;
            try {
                meta = this.metadataService.getRepo(command.projectName(), command.repositoryName()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CentralDogmaException("Unexpected exception caught while retrieving " + RepositoryMetadata.class.getSimpleName(), (Throwable)e);
            }
            writeQuota = meta.writeQuota();
        }
        if (writeQuota == null) {
            writeQuota = this.writeQuota;
        }
        this.setWriteQuota(command.projectName(), command.repositoryName(), writeQuota);
        Map.Entry entry = (Map.Entry)this.semaphoreMap.get(ZooKeeperCommandExecutor.rateLimiterKey(command.projectName(), command.repositoryName()));
        if (entry == UNLIMITED_SEMAPHORE) {
            return null;
        }
        assert (writeQuota != null);
        InterProcessSemaphoreV2 semaphore = (InterProcessSemaphoreV2)entry.getKey();
        Lease lease = semaphore.acquire(200L, TimeUnit.MILLISECONDS);
        return new WriteLock(semaphore, lease, writeQuota);
    }

    @Override
    public void setWriteQuota(String projectName, String repoName, @Nullable QuotaConfig writeQuota) {
        QuotaConfig quota = (QuotaConfig)MoreObjects.firstNonNull((Object)writeQuota, (Object)UNLIMITED_QUOTA);
        this.writeQuotaCache.put((Object)ZooKeeperCommandExecutor.rateLimiterKey(projectName, repoName), (Object)quota);
        this.semaphoreMap.compute(ZooKeeperCommandExecutor.rateLimiterKey(projectName, repoName), (k, v) -> {
            if (quota == UNLIMITED_QUOTA) {
                return UNLIMITED_SEMAPHORE;
            }
            int requestQuota = quota.requestQuota();
            if (v == null || v == UNLIMITED_SEMAPHORE) {
                SettableSharedCount cnt = new SettableSharedCount(requestQuota);
                return new AbstractMap.SimpleImmutableEntry<InterProcessSemaphoreV2, SettableSharedCount>(new InterProcessSemaphoreV2(this.curator, ZooKeeperCommandExecutor.absolutePath(QUOTA_PATH, k), (SharedCountReader)cnt), cnt);
            }
            SettableSharedCount count = (SettableSharedCount)v.getValue();
            if (count.getCount() != requestQuota) {
                count.setCount(requestQuota);
            }
            return v;
        });
    }

    private static String rateLimiterKey(String projectName, String repoName) {
        return projectName + '/' + repoName;
    }

    private void scheduleWriteLockRelease(WriteLock writeLock, InterProcessMutex mtx, String executionPath) {
        Lease lease = writeLock.lease;
        QuotaConfig writeQuota = writeLock.writeQuota;
        if (lease == null) {
            ZooKeeperCommandExecutor.safeRelease(mtx);
            throw new TooManyRequestsException("commits", executionPath, writeQuota.permitsPerSecond());
        }
        this.quotaExecutor.schedule(() -> writeLock.semaphore.returnLease(lease), (long)writeQuota.timeWindowSeconds(), TimeUnit.SECONDS);
    }

    private static String path(String ... pathElements) {
        StringBuilder sb = new StringBuilder();
        for (String path : pathElements) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.isEmpty()) continue;
            sb.append('/');
            sb.append(path);
        }
        return sb.toString();
    }

    private static String absolutePath(String ... pathElements) {
        if (pathElements.length == 0) {
            return PATH_PREFIX;
        }
        return ZooKeeperCommandExecutor.path(PATH_PREFIX, ZooKeeperCommandExecutor.path(pathElements));
    }

    private long storeLog(ReplicationLog<?> log) {
        try {
            byte[] bytes = Jackson.writeValueAsBytes(log);
            assert (bytes.length > 0);
            LogMeta logMeta = new LogMeta(log.replicaId(), System.currentTimeMillis(), bytes.length);
            int count = (bytes.length + 1047552 - 1) / 1047552;
            for (int i = 0; i < count; ++i) {
                int start = i * 1047552;
                int end = Math.min((i + 1) * 1047552, bytes.length);
                byte[] b = Arrays.copyOfRange(bytes, start, end);
                String blockPath = (String)((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(ZooKeeperCommandExecutor.absolutePath(LOG_BLOCK_PATH) + '/', b);
                long blockId = ZooKeeperCommandExecutor.revisionFromPath(blockPath);
                logMeta.appendBlock(blockId);
            }
            String logPath = (String)((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(ZooKeeperCommandExecutor.absolutePath(LOG_PATH) + '/', Jackson.writeValueAsBytes((Object)logMeta));
            return ZooKeeperCommandExecutor.revisionFromPath(logPath);
        }
        catch (Exception e) {
            logger.error("Failed to store a log; entering read-only mode: {}", log, (Object)e);
            this.stopLater();
            throw new ReplicationException("failed to store a log: " + log, e);
        }
    }

    @VisibleForTesting
    Optional<ReplicationLog<?>> loadLog(long revision, boolean skipIfSameReplica) {
        try {
            this.createParentNodes();
            String logPath = ZooKeeperCommandExecutor.absolutePath(LOG_PATH) + '/' + ZooKeeperCommandExecutor.pathFromRevision(revision);
            LogMeta logMeta = (LogMeta)Jackson.readValue((byte[])((byte[])this.curator.getData().forPath(logPath)), LogMeta.class);
            if (skipIfSameReplica && this.replicaId() == logMeta.replicaId()) {
                return Optional.empty();
            }
            byte[] bytes = new byte[logMeta.size()];
            int offset = 0;
            for (long blockId : logMeta.blocks()) {
                String blockPath = ZooKeeperCommandExecutor.absolutePath(LOG_BLOCK_PATH) + '/' + ZooKeeperCommandExecutor.pathFromRevision(blockId);
                byte[] b = (byte[])this.curator.getData().forPath(blockPath);
                System.arraycopy(b, 0, bytes, offset, b.length);
                offset += b.length;
            }
            assert (logMeta.size() == offset);
            ReplicationLog log = (ReplicationLog)Jackson.readValue((byte[])bytes, ReplicationLog.class);
            return Optional.of(log);
        }
        catch (Exception e) {
            logger.error("Failed to load a log at revision {}; entering read-only mode", (Object)revision, (Object)e);
            this.stopLater();
            throw new ReplicationException("failed to load a log at revision " + revision, e);
        }
    }

    private static long revisionFromPath(String path) {
        String[] s = path.split("/");
        return Long.parseLong(s[s.length - 1]);
    }

    private static String pathFromRevision(long revision) {
        return String.format("%010d", revision);
    }

    @Override
    protected <T> CompletableFuture<T> doExecute(Command<T> command) throws Exception {
        CompletableFuture future = new CompletableFuture();
        ExecutorService executor = this.executor;
        if (command.type() == CommandType.UPDATE_SERVER_STATUS && !((UpdateServerStatusCommand)command).serverStatus().replicating()) {
            executor = ForkJoinPool.commonPool();
        }
        executor.execute(() -> {
            try {
                future.complete(this.blockingExecute(command));
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    private <T> T blockingExecute(Command<T> command) throws Exception {
        this.createParentNodes();
        try (SafeCloseable ignored = this.safeLock(command);){
            ReplicationLog<Object> log;
            List recentRevisions = (List)this.curator.getChildren().forPath(ZooKeeperCommandExecutor.absolutePath(LOG_PATH));
            if (!recentRevisions.isEmpty()) {
                long lastRevision = recentRevisions.stream().mapToLong(Long::parseLong).max().getAsLong();
                this.replayLogs(lastRevision);
            }
            T result = this.delegate.execute(command).get();
            Command<?> maybeUnwrapped = ZooKeeperCommandExecutor.unwrapForcePush(command);
            if (maybeUnwrapped instanceof NormalizableCommit) {
                NormalizableCommit normalizingPushCommand = (NormalizableCommit)((Object)maybeUnwrapped);
                assert (result instanceof CommitResult) : result;
                CommitResult commitResult = (CommitResult)result;
                PushAsIsCommand pushAsIsCommand = normalizingPushCommand.asIs(commitResult);
                log = new ReplicationLog<Revision>(this.replicaId(), ZooKeeperCommandExecutor.maybeWrap(command, pushAsIsCommand), commitResult.revision());
            } else {
                log = new ReplicationLog<T>(this.replicaId(), command, result);
            }
            long revision = this.storeLog(log);
            if (command.type() == CommandType.UPDATE_SERVER_STATUS) {
                UpdateServerStatusCommand statusCommand = (UpdateServerStatusCommand)command;
                this.canReplicate = statusCommand.serverStatus().replicating();
                this.statusManager().updateStatus(statusCommand);
            }
            logger.debug("logging OK. revision = {}, log = {}", (Object)revision, log);
            T t = result;
            return t;
        }
    }

    private static Command<?> unwrapForcePush(Command<?> command) {
        if (command.type() == CommandType.FORCE_PUSH) {
            return ((ForcePushCommand)command).delegate();
        }
        return command;
    }

    private static <T> Command<Revision> maybeWrap(Command<T> oldCommand, Command<Revision> pushAsIsCommand) {
        if (oldCommand.type() == CommandType.FORCE_PUSH) {
            return Command.forcePush(pushAsIsCommand);
        }
        return pushAsIsCommand;
    }

    private void createParentNodes() throws Exception {
        if (this.createdParentNodes) {
            return;
        }
        this.createZkPathIfMissing(ZooKeeperCommandExecutor.absolutePath(new String[0]));
        this.createZkPathIfMissing(ZooKeeperCommandExecutor.absolutePath(LOG_PATH));
        this.createZkPathIfMissing(ZooKeeperCommandExecutor.absolutePath(LOG_BLOCK_PATH));
        this.createZkPathIfMissing(ZooKeeperCommandExecutor.absolutePath(LOCK_PATH));
        this.createdParentNodes = true;
    }

    private void createZkPathIfMissing(String zkPath) throws Exception {
        try {
            this.curator.create().forPath(zkPath);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @VisibleForTesting
    void setLockTimeoutMillis(long lockTimeoutMillis) {
        this.lockTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(lockTimeoutMillis);
    }

    private static final class ListenerInfo {
        long lastReplayedRevision;
        @Nullable
        final Runnable onTakeLeadership;
        @Nullable
        final Runnable onReleaseLeadership;
        @Nullable
        final Runnable onTakeZoneLeadership;
        @Nullable
        final Runnable onReleaseZoneLeadership;

        ListenerInfo(long lastReplayedRevision, @Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership, @Nullable Runnable onTakeZoneLeadership, @Nullable Runnable onReleaseZoneLeadership) {
            this.lastReplayedRevision = lastReplayedRevision;
            this.onReleaseLeadership = onReleaseLeadership;
            this.onTakeLeadership = onTakeLeadership;
            this.onTakeZoneLeadership = onTakeZoneLeadership;
            this.onReleaseZoneLeadership = onReleaseZoneLeadership;
        }
    }

    private class OldLogRemover
    implements LeaderSelectorListener {
        volatile boolean hasLeadership;

        private OldLogRemover() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void takeLeadership(CuratorFramework client) throws Exception {
            ListenerInfo listenerInfo = ZooKeeperCommandExecutor.this.listenerInfo;
            if (listenerInfo == null) {
                return;
            }
            logger.info("Taking leadership: {}", (Object)ZooKeeperCommandExecutor.this.replicaId());
            try {
                this.hasLeadership = true;
                if (listenerInfo.onTakeLeadership != null) {
                    listenerInfo.onTakeLeadership.run();
                }
                while (ZooKeeperCommandExecutor.this.curator.getState() == CuratorFrameworkState.STARTED) {
                    this.deleteLogs();
                    OldLogRemover oldLogRemover = this;
                    synchronized (oldLogRemover) {
                        this.wait();
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Exception e) {
                logger.error("Leader stopped due to an unexpected exception:", (Throwable)e);
                return;
            }
            finally {
                this.hasLeadership = false;
                logger.info("Releasing leadership: {}", (Object)ZooKeeperCommandExecutor.this.replicaId());
                if (listenerInfo.onReleaseLeadership != null) {
                    listenerInfo.onReleaseLeadership.run();
                }
                if (ZooKeeperCommandExecutor.this.listenerInfo != null) {
                    ZooKeeperCommandExecutor.this.leaderSelector.requeue();
                }
            }
        }

        public synchronized void touch() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteLogs() throws Exception {
            List children = (List)ZooKeeperCommandExecutor.this.curator.getChildren().forPath(ZooKeeperCommandExecutor.absolutePath(new String[]{ZooKeeperCommandExecutor.LOG_PATH}));
            if (children.size() <= ZooKeeperCommandExecutor.this.cfg.maxLogCount()) {
                return;
            }
            long minAllowedTimestamp = System.currentTimeMillis() - ZooKeeperCommandExecutor.this.cfg.minLogAgeMillis();
            int targetCount = children.size() - ZooKeeperCommandExecutor.this.cfg.maxLogCount();
            ArrayList<String> deletedPaths = new ArrayList<String>(targetCount);
            children.sort(Comparator.comparingLong(Long::parseLong));
            try {
                for (int i = 0; i < targetCount; ++i) {
                    String childName = (String)children.get(i);
                    String logPath = ZooKeeperCommandExecutor.absolutePath(new String[]{ZooKeeperCommandExecutor.LOG_PATH, childName});
                    LogMeta logMeta = this.readLogMeta(logPath);
                    if (logMeta == null) continue;
                    if (logMeta.timestamp() >= minAllowedTimestamp) {
                        break;
                    }
                    for (long blockId : logMeta.blocks()) {
                        String blockPath = ZooKeeperCommandExecutor.absolutePath(new String[]{ZooKeeperCommandExecutor.LOG_BLOCK_PATH}) + '/' + ZooKeeperCommandExecutor.pathFromRevision(blockId);
                        this.deleteLogBlock(logPath, logMeta, blockPath, deletedPaths);
                    }
                    this.deleteLog(logPath, logMeta, deletedPaths);
                }
            }
            finally {
                logger.info("Deleted ZooKeeper nodes: {}", deletedPaths);
            }
        }

        @Nullable
        private LogMeta readLogMeta(String logPath) throws Exception {
            try {
                return (LogMeta)Jackson.readValue((byte[])((byte[])ZooKeeperCommandExecutor.this.curator.getData().forPath(logPath)), LogMeta.class);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) {
                    logger.warn("Attempted to read a missing log from ZooKeeper; maybe deleted already? logPath: {}", (Object)logPath, (Object)e);
                    return null;
                }
                throw e;
            }
        }

        private void deleteLog(String logPath, LogMeta logMeta, List<String> deletedPaths) throws Exception {
            try {
                ZooKeeperCommandExecutor.this.curator.delete().forPath(logPath);
                deletedPaths.add(logPath);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) {
                    logger.warn("Attempted to delete a missing log from ZooKeeper; maybe deleted already? logPath: {}, logMeta: {}", new Object[]{logPath, logMeta, e});
                }
                throw e;
            }
        }

        private void deleteLogBlock(String logPath, LogMeta logMeta, String blockPath, List<String> deletedPaths) throws Exception {
            try {
                ZooKeeperCommandExecutor.this.curator.delete().forPath(blockPath);
                deletedPaths.add(blockPath);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) {
                    logger.warn("Attempted to delete a missing log block from ZooKeeper; maybe deleted already? blockPath: {}, logPath: {}, logMeta: {}", new Object[]{blockPath, logPath, logMeta, e});
                }
                throw e;
            }
        }
    }

    private class ZoneLeaderPluginsRunner
    implements LeaderSelectorListener {
        volatile boolean hasLeadership;

        private ZoneLeaderPluginsRunner() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void takeLeadership(CuratorFramework client) throws Exception {
            ListenerInfo listenerInfo = ZooKeeperCommandExecutor.this.listenerInfo;
            if (listenerInfo == null) {
                return;
            }
            logger.info("Taking the {} zone leadership: {}", (Object)ZooKeeperCommandExecutor.this.zone, (Object)ZooKeeperCommandExecutor.this.replicaId());
            try {
                this.hasLeadership = true;
                if (listenerInfo.onTakeZoneLeadership != null) {
                    listenerInfo.onTakeZoneLeadership.run();
                }
                ZoneLeaderPluginsRunner zoneLeaderPluginsRunner = this;
                synchronized (zoneLeaderPluginsRunner) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                logger.error("Leader stopped due to an unexpected exception:", (Throwable)e);
            }
            finally {
                this.hasLeadership = false;
                logger.info("Releasing the zone {} leadership: {}", (Object)ZooKeeperCommandExecutor.this.zone, (Object)ZooKeeperCommandExecutor.this.replicaId());
                if (listenerInfo.onReleaseZoneLeadership != null) {
                    listenerInfo.onReleaseZoneLeadership.run();
                }
                if (ZooKeeperCommandExecutor.this.listenerInfo != null) {
                    ZooKeeperCommandExecutor.this.zoneLeaderSelector.requeue();
                }
            }
        }
    }

    private static final class WriteLock {
        private final InterProcessSemaphoreV2 semaphore;
        @Nullable
        private final Lease lease;
        private final QuotaConfig writeQuota;

        private WriteLock(InterProcessSemaphoreV2 semaphore, @Nullable Lease lease, QuotaConfig writeQuota) {
            this.semaphore = semaphore;
            this.lease = lease;
            this.writeQuota = writeQuota;
        }
    }

    private static class LogMeta {
        private final int replicaId;
        private final long timestamp;
        private final int size;
        private final List<Long> blocks = new ArrayList<Long>();

        @JsonCreator
        LogMeta(@JsonProperty(value="replicaId", required=true) int replicaId, @JsonProperty(value="timestamp", defaultValue="0") Long timestamp, @JsonProperty(value="size") int size) {
            this.replicaId = replicaId;
            if (timestamp == null) {
                timestamp = 0L;
            }
            this.timestamp = timestamp;
            this.size = size;
        }

        @JsonProperty
        int replicaId() {
            return this.replicaId;
        }

        @JsonProperty
        long timestamp() {
            return this.timestamp;
        }

        @JsonProperty
        int size() {
            return this.size;
        }

        @JsonProperty
        List<Long> blocks() {
            return Collections.unmodifiableList(this.blocks);
        }

        public void appendBlock(long blockId) {
            this.blocks.add(blockId);
        }
    }
}

