/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.curator.framework.recipes.shared.SharedCountListener;
import org.apache.curator.framework.recipes.shared.SharedCountReader;
import org.apache.curator.framework.recipes.shared.VersionedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SettableSharedCount
implements SharedCountReader {
    private static final Logger logger = LoggerFactory.getLogger(SettableSharedCount.class);
    private final List<SharedCountListener> listeners;
    private int count;

    SettableSharedCount(int count) {
        this.count = count;
        this.listeners = new ArrayList<SharedCountListener>();
    }

    void setCount(int count) {
        this.count = count;
        for (SharedCountListener listener : this.listeners) {
            try {
                listener.countHasChanged((SharedCountReader)this, count);
            }
            catch (Exception e) {
                logger.warn("Unexpected exception caught while notifying {}", (Object)listener, (Object)e);
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public VersionedValue<Integer> getVersionedValue() {
        throw new UnsupportedOperationException();
    }

    public void addListener(SharedCountListener listener) {
        this.listeners.add(listener);
    }

    public void addListener(SharedCountListener listener, Executor executor) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(SharedCountListener listener) {
        throw new UnsupportedOperationException();
    }
}

