/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.internal.mirror.MirrorSchedulingService;
import com.linecorp.centraldogma.server.mirror.MirroringServicePluginConfig;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public final class DefaultMirroringServicePlugin
implements Plugin {
    @Nullable
    private volatile MirrorSchedulingService mirroringService;

    @Override
    public PluginTarget target() {
        return PluginTarget.LEADER_ONLY;
    }

    @Override
    public synchronized CompletionStage<Void> start(PluginContext context) {
        Objects.requireNonNull(context, "context");
        MirrorSchedulingService mirroringService = this.mirroringService;
        if (mirroringService == null) {
            long maxNumBytesPerMirror;
            int maxNumFilesPerMirror;
            int numThreads;
            CentralDogmaConfig cfg = context.config();
            MirroringServicePluginConfig mirroringServicePluginConfig = (MirroringServicePluginConfig)cfg.pluginConfigMap().get(this.configType());
            if (mirroringServicePluginConfig != null) {
                numThreads = mirroringServicePluginConfig.numMirroringThreads();
                maxNumFilesPerMirror = mirroringServicePluginConfig.maxNumFilesPerMirror();
                maxNumBytesPerMirror = mirroringServicePluginConfig.maxNumBytesPerMirror();
            } else {
                numThreads = MirroringServicePluginConfig.INSTANCE.numMirroringThreads();
                maxNumFilesPerMirror = MirroringServicePluginConfig.INSTANCE.maxNumFilesPerMirror();
                maxNumBytesPerMirror = MirroringServicePluginConfig.INSTANCE.maxNumBytesPerMirror();
            }
            this.mirroringService = mirroringService = new MirrorSchedulingService(new File(cfg.dataDir(), "_mirrors"), context.projectManager(), context.meterRegistry(), numThreads, maxNumFilesPerMirror, maxNumBytesPerMirror);
        }
        mirroringService.start(context.commandExecutor());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletionStage<Void> stop(PluginContext context) {
        MirrorSchedulingService mirroringService = this.mirroringService;
        if (mirroringService != null && mirroringService.isStarted()) {
            mirroringService.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Class<?> configType() {
        return MirroringServicePluginConfig.class;
    }

    @Nullable
    public MirrorSchedulingService mirroringService() {
        return this.mirroringService;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("configType", this.configType()).add("target", (Object)this.target()).toString();
    }
}

