/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.server.mirror.MirrorListener;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.mirror.MirrorTask;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompositeMirrorListener
implements MirrorListener {
    private static final Logger logger = LoggerFactory.getLogger(CompositeMirrorListener.class);
    private final List<MirrorListener> delegates;

    CompositeMirrorListener(List<MirrorListener> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void onStart(MirrorTask mirrorTask) {
        for (MirrorListener delegate : this.delegates) {
            try {
                delegate.onStart(mirrorTask);
            }
            catch (Exception e) {
                logger.warn("Failed to notify a listener of the mirror start event: {}", (Object)delegate, (Object)e);
            }
        }
    }

    @Override
    public void onComplete(MirrorTask mirrorTask, MirrorResult result) {
        for (MirrorListener delegate : this.delegates) {
            try {
                delegate.onComplete(mirrorTask, result);
            }
            catch (Exception e) {
                logger.warn("Failed to notify a listener of the mirror complete event: {}", (Object)delegate, (Object)e);
            }
        }
    }

    @Override
    public void onError(MirrorTask mirrorTask, Throwable cause) {
        for (MirrorListener delegate : this.delegates) {
            try {
                delegate.onError(mirrorTask, cause);
            }
            catch (Exception e) {
                logger.warn("Failed to notify a listener of the mirror error event: {}", (Object)delegate, (Object)e);
            }
        }
    }
}

