/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.internal.credential.AbstractCredential;
import com.linecorp.centraldogma.server.internal.credential.CredentialUtil;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessTokenCredential
extends AbstractCredential {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenCredential.class);
    private final String accessToken;

    @JsonCreator
    public AccessTokenCredential(@JsonProperty(value="id") String id, @JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="accessToken") String accessToken) {
        super(id, enabled, "access_token");
        this.accessToken = CredentialUtil.requireNonEmpty(accessToken, "accessToken");
    }

    public String accessToken() {
        try {
            return CentralDogmaConfig.convertValue(this.accessToken, "credentials.accessToken");
        }
        catch (Throwable t) {
            logger.debug("Failed to convert the access token of the credential: {}", (Object)this.id(), (Object)t);
            return this.accessToken;
        }
    }

    @JsonProperty(value="accessToken")
    public String rawAccessToken() {
        return this.accessToken;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.accessToken.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessTokenCredential)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessTokenCredential that = (AccessTokenCredential)o;
        return this.accessToken.equals(that.accessToken);
    }

    @Override
    void addProperties(MoreObjects.ToStringHelper helper) {
    }

    @Override
    public Credential withoutSecret() {
        return new AccessTokenCredential(this.id(), this.enabled(), "****");
    }
}

