/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.credential;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.credential.Credential;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class AbstractCredential
implements Credential {
    private final String id;
    private final boolean enabled;
    private final String type;

    AbstractCredential(String id, @Nullable Boolean enabled, String type) {
        this.id = Objects.requireNonNull(id, "id");
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)true);
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public final String id() {
        return this.id;
    }

    @JsonProperty(value="type")
    public final String type() {
        return this.type;
    }

    @Override
    public final boolean enabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCredential that = (AbstractCredential)o;
        return this.enabled == that.enabled && this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode() * 31 + Boolean.hashCode(this.enabled);
    }

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("id", (Object)this.id);
        helper.add("type", (Object)this.type);
        helper.add("enabled", this.enabled);
        this.addProperties(helper);
        return helper.toString();
    }

    abstract void addProperties(MoreObjects.ToStringHelper var1);
}

