/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.ContextAwareBlockingTaskExecutor;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.internal.api.v1.CreateProjectRequest;
import com.linecorp.centraldogma.internal.api.v1.ProjectDto;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresAdministrator;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRole;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.metadata.Member;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.metadata.UserWithToken;
import com.linecorp.centraldogma.server.storage.project.Project;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@ProducesJson
public class ProjectServiceV1
extends AbstractService {
    private final ProjectApiManager projectApiManager;

    public ProjectServiceV1(ProjectApiManager projectApiManager, CommandExecutor executor) {
        super(executor);
        this.projectApiManager = Objects.requireNonNull(projectApiManager, "projectApiManager");
    }

    @Get(value="/projects")
    public CompletableFuture<List<ProjectDto>> listProjects(@Param @Nullable String status, User user) {
        ContextAwareBlockingTaskExecutor executor = ServiceRequestContext.current().blockingTaskExecutor();
        if (status != null) {
            HttpApiUtil.checkStatusArgument(status);
            return CompletableFuture.supplyAsync(() -> (List)this.projectApiManager.listRemovedProjects().keySet().stream().map(ProjectDto::new).collect(ImmutableList.toImmutableList()), (Executor)executor);
        }
        return CompletableFuture.supplyAsync(() -> (List)this.projectApiManager.listProjects(user).values().stream().map(project -> DtoConverter.convert(project, ProjectServiceV1.getUserRole(project, user))).collect(ImmutableList.toImmutableList()), (Executor)executor);
    }

    private static ProjectRole getUserRole(Project project, User user) {
        if (user.isAdmin()) {
            return ProjectRole.OWNER;
        }
        ProjectMetadata metadata = project.metadata();
        if (metadata == null) {
            return ProjectRole.GUEST;
        }
        ProjectRole role = null;
        if (user instanceof UserWithToken) {
            String appId = ((UserWithToken)user).token().appId();
            TokenRegistration tokenRegistration = metadata.tokens().get(appId);
            if (tokenRegistration != null) {
                role = tokenRegistration.role();
            }
        } else {
            Member member = metadata.memberOrDefault(user.id(), null);
            if (member != null) {
                role = member.role();
            }
        }
        if (role == null) {
            role = ProjectRole.GUEST;
        }
        return role;
    }

    @Post(value="/projects")
    @StatusCode(value=201)
    @ResponseConverter(value=CreateApiResponseConverter.class)
    public CompletableFuture<ProjectDto> createProject(CreateProjectRequest request, Author author, User user) {
        return this.projectApiManager.createProject(request.name(), author).handle(HttpApiUtil.returnOrThrow(() -> {
            Project project = this.projectApiManager.getProject(request.name(), user);
            return DtoConverter.convert(project, ProjectRole.OWNER);
        }));
    }

    @Get(value="/projects/{projectName}")
    @RequiresRole(roles={ProjectRole.OWNER, ProjectRole.MEMBER})
    public CompletableFuture<ProjectMetadata> getProjectMetadata(@Param String projectName, @Param(value="checkPermissionOnly") @Default(value="false") boolean isCheckPermissionOnly) {
        if (isCheckPermissionOnly) {
            return CompletableFuture.completedFuture(null);
        }
        return this.projectApiManager.getProjectMetadata(projectName);
    }

    @Delete(value="/projects/{projectName}")
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<Void> removeProject(Project project, Author author) {
        return this.projectApiManager.removeProject(project.name(), author);
    }

    @Delete(value="/projects/{projectName}/removed")
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<Void> purgeProject(@Param String projectName, Author author) {
        return this.projectApiManager.purgeProject(projectName, author);
    }

    @Consumes(value="application/json-patch+json")
    @Patch(value="/projects/{projectName}")
    @RequiresAdministrator
    public CompletableFuture<ProjectDto> patchProject(@Param String projectName, JsonNode node, Author author, User user) {
        HttpApiUtil.checkUnremoveArgument(node);
        return this.projectApiManager.unremoveProject(projectName, author).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert(this.projectApiManager.getProject(projectName, user), ProjectRole.OWNER)));
    }
}

