/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.armeria.server.annotation.decorator.RequestTimeout;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.MirrorDto;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.internal.mirror.MirrorRunner;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@ProducesJson
public class MirroringServiceV1
extends AbstractService {
    private final ProjectApiManager projectApiManager;
    private final MirrorRunner mirrorRunner;

    public MirroringServiceV1(ProjectApiManager projectApiManager, CommandExecutor executor, MirrorRunner mirrorRunner) {
        super(executor);
        this.projectApiManager = projectApiManager;
        this.mirrorRunner = mirrorRunner;
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/mirrors")
    public CompletableFuture<List<MirrorDto>> listMirrors(@Param String projectName) {
        return this.metaRepo(projectName).mirrors(true).thenApply(mirrors -> (List)mirrors.stream().map(mirror -> MirroringServiceV1.convertToMirrorDto(projectName, mirror)).collect(ImmutableList.toImmutableList()));
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/mirrors/{id}")
    public CompletableFuture<MirrorDto> getMirror(@Param String projectName, @Param String id) {
        return this.metaRepo(projectName).mirror(id).thenApply(mirror -> MirroringServiceV1.convertToMirrorDto(projectName, mirror));
    }

    @RequiresWritePermission(repository="meta")
    @Post(value="/projects/{projectName}/mirrors")
    @ConsumesJson
    @StatusCode(value=201)
    public CompletableFuture<PushResultDto> createMirror(@Param String projectName, MirrorDto newMirror, Author author) {
        return this.createOrUpdate(projectName, newMirror, author, false);
    }

    @RequiresWritePermission(repository="meta")
    @Put(value="/projects/{projectName}/mirrors/{id}")
    @ConsumesJson
    public CompletableFuture<PushResultDto> updateMirror(@Param String projectName, MirrorDto mirror, @Param String id, Author author) {
        Preconditions.checkArgument((boolean)id.equals(mirror.id()), (String)"The mirror ID (%s) can't be updated", (Object)id);
        return this.createOrUpdate(projectName, mirror, author, true);
    }

    @RequiresWritePermission(repository="meta")
    @Delete(value="/projects/{projectName}/mirrors/{id}")
    public CompletableFuture<Void> deleteMirror(@Param String projectName, @Param String id, Author author) {
        MetaRepository metaRepository = this.metaRepo(projectName);
        return metaRepository.mirror(id).thenCompose(mirror -> {
            Command<CommitResult> command = Command.push(author, projectName, metaRepository.name(), Revision.HEAD, "Delete mirror: " + id, "", Markup.PLAINTEXT, Change.ofRemoval((String)DefaultMetaRepository.mirrorFile(id)));
            return this.executor().execute(command).thenApply(result -> null);
        });
    }

    private CompletableFuture<PushResultDto> createOrUpdate(String projectName, MirrorDto newMirror, Author author, boolean update) {
        return this.metaRepo(projectName).createPushCommand(newMirror, author, update).thenCompose(command -> this.executor().execute(command).thenApply(result -> new PushResultDto(result.revision(), command.timestamp())));
    }

    @RequiresWritePermission(repository="meta")
    @RequestTimeout(value=5L, unit=TimeUnit.MINUTES)
    @Post(value="/projects/{projectName}/mirrors/{mirrorId}/run")
    public CompletableFuture<MirrorResult> runMirror(@Param String projectName, @Param String mirrorId, User user) throws Exception {
        return this.mirrorRunner.run(projectName, mirrorId, user);
    }

    private static MirrorDto convertToMirrorDto(String projectName, Mirror mirror) {
        URI remoteRepoUri = mirror.remoteRepoUri();
        Cron schedule = mirror.schedule();
        String scheduleStr = schedule != null ? schedule.asString() : null;
        return new MirrorDto(mirror.id(), Boolean.valueOf(mirror.enabled()), projectName, scheduleStr, mirror.direction().name(), mirror.localRepo().name(), mirror.localPath(), remoteRepoUri.getScheme(), remoteRepoUri.getHost() + remoteRepoUri.getPath(), mirror.remotePath(), mirror.remoteBranch(), mirror.gitignore(), mirror.credential().id());
    }

    private MetaRepository metaRepo(String projectName) {
        return this.projectApiManager.getProject(projectName).metaRepo();
    }
}

