/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.AuthorizationException;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.EntryNoContentException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.InvalidPushException;
import com.linecorp.centraldogma.common.MirrorException;
import com.linecorp.centraldogma.common.PermissionException;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.ReadOnlyException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.TooManyRequestsException;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.internal.admin.service.TokenNotFoundException;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.RequestAlreadyTimedOutException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import java.util.Map;
import java.util.function.BiFunction;

public final class HttpApiExceptionHandler
implements ServerErrorHandler {
    private static final Map<Class<?>, BiFunction<ServiceRequestContext, Throwable, HttpResponse>> exceptionHandlers;

    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        Throwable peeledCause = Exceptions.peel((Throwable)cause);
        if (peeledCause instanceof HttpStatusException || peeledCause instanceof HttpResponseException) {
            return null;
        }
        BiFunction<ServiceRequestContext, Throwable, HttpResponse> func = exceptionHandlers.get(peeledCause.getClass());
        if (func != null) {
            ctx.setShouldReportUnloggedExceptions(false);
            return func.apply(ctx, peeledCause);
        }
        if (peeledCause instanceof IllegalArgumentException) {
            ctx.setShouldReportUnloggedExceptions(false);
            return HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, peeledCause);
        }
        if (peeledCause instanceof RequestAlreadyTimedOutException) {
            ctx.setShouldReportUnloggedExceptions(false);
            return HttpApiUtil.newResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, peeledCause);
        }
        return HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, peeledCause);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ChangeConflictException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "The given changeset or revision has a conflict.")).put(EntryNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Entry '%s' does not exist.", cause.getMessage())).put(EntryNoContentException.class, (ctx, cause) -> HttpResponse.of((HttpStatus)HttpStatus.NO_CONTENT)).put(ProjectExistsException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "Project '%s' exists already.", cause.getMessage())).put(ProjectNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Project '%s' does not exist.", cause.getMessage())).put(RedundantChangeException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "The given changeset does not change anything.")).put(RepositoryExistsException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "Repository '%s' exists already.", cause.getMessage())).put(RepositoryMetadataException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, cause)).put(RepositoryNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Repository '%s' does not exist.", cause.getMessage())).put(RevisionNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Revision %s does not exist.", cause.getMessage())).put(TokenNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Token '%s' does not exist.", cause.getMessage())).put(QueryExecutionException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, cause)).put(UnsupportedOperationException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, cause)).put(TooManyRequestsException.class, (ctx, cause) -> {
            TooManyRequestsException cast = (TooManyRequestsException)cause;
            Object type = MoreObjects.firstNonNull((Object)cast.type(), (Object)"requests");
            return HttpApiUtil.newResponse(ctx, HttpStatus.TOO_MANY_REQUESTS, (Throwable)cast, "Too many %s are sent to %s", type, cause.getMessage());
        }).put(InvalidPushException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, cause)).put(ReadOnlyException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, cause)).put(MirrorException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, cause)).put(AuthorizationException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.UNAUTHORIZED, cause)).put(PermissionException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.FORBIDDEN, cause));
        exceptionHandlers = builder.build();
    }
}

