/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ProducesJson
public class CredentialServiceV1
extends AbstractService {
    private final ProjectApiManager projectApiManager;

    public CredentialServiceV1(ProjectApiManager projectApiManager, CommandExecutor executor) {
        super(executor);
        this.projectApiManager = projectApiManager;
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/credentials")
    public CompletableFuture<List<Credential>> listCredentials(User loginUser, @Param String projectName) {
        CompletableFuture<List<Credential>> future = this.metaRepo(projectName, loginUser).credentials();
        if (loginUser.isAdmin()) {
            return future;
        }
        return future.thenApply(credentials -> (List)credentials.stream().map(Credential::withoutSecret).collect(ImmutableList.toImmutableList()));
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/credentials/{id}")
    public CompletableFuture<Credential> getCredentialById(User loginUser, @Param String projectName, @Param String id) {
        CompletableFuture<Credential> future = this.metaRepo(projectName, loginUser).credential(id);
        if (loginUser.isAdmin()) {
            return future;
        }
        return future.thenApply(Credential::withoutSecret);
    }

    @RequiresWritePermission(repository="meta")
    @Post(value="/projects/{projectName}/credentials")
    @ConsumesJson
    @StatusCode(value=201)
    public CompletableFuture<PushResultDto> createCredential(@Param String projectName, Credential credential, Author author, User user) {
        return this.createOrUpdate(projectName, credential, author, user, false);
    }

    @RequiresWritePermission(repository="meta")
    @Put(value="/projects/{projectName}/credentials/{id}")
    @ConsumesJson
    public CompletableFuture<PushResultDto> updateCredential(@Param String projectName, @Param String id, Credential credential, Author author, User user) {
        Preconditions.checkArgument((boolean)id.equals(credential.id()), (String)"The credential ID (%s) can't be updated", (Object)id);
        return this.createOrUpdate(projectName, credential, author, user, true);
    }

    @RequiresWritePermission(repository="meta")
    @Delete(value="/projects/{projectName}/credentials/{id}")
    public CompletableFuture<Void> deleteCredential(@Param String projectName, @Param String id, Author author, User user) {
        MetaRepository metaRepository = this.metaRepo(projectName, user);
        return metaRepository.credential(id).thenCompose(credential -> {
            Command<CommitResult> command = Command.push(author, projectName, metaRepository.name(), Revision.HEAD, "Delete credential: " + id, "", Markup.PLAINTEXT, Change.ofRemoval((String)DefaultMetaRepository.credentialFile(id)));
            return this.executor().execute(command).thenApply(result -> null);
        });
    }

    private CompletableFuture<PushResultDto> createOrUpdate(String projectName, Credential credential, Author author, User user, boolean update) {
        return this.metaRepo(projectName, user).createPushCommand(credential, author, update).thenCompose(command -> this.executor().execute(command).thenApply(result -> new PushResultDto(result.revision(), command.timestamp())));
    }

    private MetaRepository metaRepo(String projectName, User user) {
        return this.projectApiManager.getProject(projectName, user).metaRepo();
    }
}

