/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CsrfTokenAuthorizer
implements Authorizer<HttpRequest> {
    public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest data) {
        OAuth2Token token = (OAuth2Token)AuthTokenExtractors.oAuth2().apply(data.headers());
        if (token != null && "anonymous".equals(token.accessToken())) {
            AuthUtil.setCurrentUser(ctx, User.ADMIN);
            HttpApiUtil.setVerboseResponses(ctx, User.ADMIN);
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(false);
    }
}

