/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.linecorp.centraldogma.common.TooManyRequestsException;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.RateLimiter;
import com.linecorp.centraldogma.server.QuotaConfig;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.command.AbstractCommandExecutor;
import com.linecorp.centraldogma.server.command.AbstractPushCommand;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.CreateProjectCommand;
import com.linecorp.centraldogma.server.command.CreateRepositoryCommand;
import com.linecorp.centraldogma.server.command.CreateSessionCommand;
import com.linecorp.centraldogma.server.command.ForcePushCommand;
import com.linecorp.centraldogma.server.command.NormalizingPushCommand;
import com.linecorp.centraldogma.server.command.PurgeProjectCommand;
import com.linecorp.centraldogma.server.command.PurgeRepositoryCommand;
import com.linecorp.centraldogma.server.command.PushAsIsCommand;
import com.linecorp.centraldogma.server.command.RemoveProjectCommand;
import com.linecorp.centraldogma.server.command.RemoveRepositoryCommand;
import com.linecorp.centraldogma.server.command.RemoveSessionCommand;
import com.linecorp.centraldogma.server.command.RepositoryCommand;
import com.linecorp.centraldogma.server.command.TransformCommand;
import com.linecorp.centraldogma.server.command.UnremoveProjectCommand;
import com.linecorp.centraldogma.server.command.UnremoveRepositoryCommand;
import com.linecorp.centraldogma.server.command.UpdateServerStatusCommand;
import com.linecorp.centraldogma.server.management.ServerStatusManager;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCommandExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneCommandExecutor.class);
    private static final RateLimiter UNLIMITED = RateLimiter.create((double)Double.MAX_VALUE);
    private final ProjectManager projectManager;
    private final Executor repositoryWorker;
    @Nullable
    private final SessionManager sessionManager;
    private final double permitsPerSecond;
    private final MetadataService metadataService;
    private final ServerStatusManager serverStatusManager;
    @VisibleForTesting
    final Map<String, RateLimiter> writeRateLimiters;

    public StandaloneCommandExecutor(ProjectManager projectManager, Executor repositoryWorker, ServerStatusManager serverStatusManager, @Nullable SessionManager sessionManager, @Nullable QuotaConfig writeQuota, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership, @Nullable Consumer<CommandExecutor> onTakeZoneLeadership, @Nullable Consumer<CommandExecutor> onReleaseZoneLeadership) {
        this(projectManager, repositoryWorker, serverStatusManager, sessionManager, writeQuota != null ? writeQuota.permitsPerSecond() : 0.0, onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
    }

    public StandaloneCommandExecutor(ProjectManager projectManager, Executor repositoryWorker, ServerStatusManager serverStatusManager, @Nullable SessionManager sessionManager, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership, @Nullable Consumer<CommandExecutor> onTakeZoneLeadership, @Nullable Consumer<CommandExecutor> onReleaseZoneLeadership) {
        this(projectManager, repositoryWorker, serverStatusManager, sessionManager, -1.0, onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
    }

    private StandaloneCommandExecutor(ProjectManager projectManager, Executor repositoryWorker, ServerStatusManager serverStatusManager, @Nullable SessionManager sessionManager, double permitsPerSecond, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership, @Nullable Consumer<CommandExecutor> onTakeZoneLeadership, @Nullable Consumer<CommandExecutor> onReleaseZoneLeadership) {
        super(onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.serverStatusManager = Objects.requireNonNull(serverStatusManager, "serverStatusManager");
        this.sessionManager = sessionManager;
        this.permitsPerSecond = permitsPerSecond;
        this.writeRateLimiters = new ConcurrentHashMap<String, RateLimiter>();
        this.metadataService = new MetadataService(projectManager, this);
    }

    @Override
    public int replicaId() {
        return 0;
    }

    @Override
    protected void doStart(@Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership, @Nullable Runnable onTakeZoneLeadership, @Nullable Runnable onReleaseZoneLeadership) {
        if (onTakeLeadership != null) {
            onTakeLeadership.run();
        }
        if (onTakeZoneLeadership != null) {
            onTakeZoneLeadership.run();
        }
    }

    @Override
    protected void doStop(@Nullable Runnable onReleaseLeadership, @Nullable Runnable onReleaseZoneLeadership) {
        if (onReleaseLeadership != null) {
            onReleaseLeadership.run();
        }
        if (onReleaseZoneLeadership != null) {
            onReleaseZoneLeadership.run();
        }
    }

    @Override
    protected <T> CompletableFuture<T> doExecute(Command<T> command) throws Exception {
        if (command instanceof CreateProjectCommand) {
            return this.createProject((CreateProjectCommand)command);
        }
        if (command instanceof RemoveProjectCommand) {
            return this.removeProject((RemoveProjectCommand)command);
        }
        if (command instanceof UnremoveProjectCommand) {
            return this.unremoveProject((UnremoveProjectCommand)command);
        }
        if (command instanceof PurgeProjectCommand) {
            return this.purgeProject((PurgeProjectCommand)command);
        }
        if (command instanceof CreateRepositoryCommand) {
            return this.createRepository((CreateRepositoryCommand)command);
        }
        if (command instanceof RemoveRepositoryCommand) {
            return this.removeRepository((RemoveRepositoryCommand)command);
        }
        if (command instanceof UnremoveRepositoryCommand) {
            return this.unremoveRepository((UnremoveRepositoryCommand)command);
        }
        if (command instanceof PurgeRepositoryCommand) {
            return this.purgeRepository((PurgeRepositoryCommand)command);
        }
        if (command instanceof NormalizingPushCommand) {
            return this.push((NormalizingPushCommand)command, true);
        }
        if (command instanceof PushAsIsCommand) {
            return this.push((PushAsIsCommand)command, false).thenApply(CommitResult::revision);
        }
        if (command instanceof TransformCommand) {
            return this.push((TransformCommand)command, true);
        }
        if (command instanceof CreateSessionCommand) {
            return this.createSession((CreateSessionCommand)command);
        }
        if (command instanceof RemoveSessionCommand) {
            return this.removeSession((RemoveSessionCommand)command);
        }
        if (command instanceof UpdateServerStatusCommand) {
            return this.updateServerStatus((UpdateServerStatusCommand)command);
        }
        if (command instanceof ForcePushCommand) {
            return this.doExecute(((ForcePushCommand)command).delegate());
        }
        throw new UnsupportedOperationException(command.toString());
    }

    private CompletableFuture<Void> createProject(CreateProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.create(c.projectName(), c.timestamp(), c.author());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeProject(RemoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.remove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveProject(UnremoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.unremove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> purgeProject(PurgeProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.markForPurge(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> createRepository(CreateRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().create(c.repositoryName(), c.timestamp(), c.author());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeRepository(RemoveRepositoryCommand c) {
        if (this.writeQuotaEnabled()) {
            this.writeRateLimiters.remove(StandaloneCommandExecutor.rateLimiterKey(c.projectName(), c.repositoryName()));
        }
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().remove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveRepository(UnremoveRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().unremove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> purgeRepository(PurgeRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().markForPurge(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<CommitResult> push(RepositoryCommand<?> c, boolean normalizing) {
        if (c.projectName().equals("dogma") || c.repositoryName().equals("dogma") || !this.writeQuotaEnabled()) {
            return this.push0(c, normalizing);
        }
        RateLimiter rateLimiter = this.writeRateLimiters.get(StandaloneCommandExecutor.rateLimiterKey(c.projectName(), c.repositoryName()));
        if (rateLimiter != null) {
            return this.tryPush(c, normalizing, rateLimiter);
        }
        return this.getRateLimiter(c.projectName(), c.repositoryName()).thenCompose(limiter -> this.tryPush(c, normalizing, (RateLimiter)limiter));
    }

    private CompletableFuture<CommitResult> tryPush(RepositoryCommand<?> c, boolean normalizing, @Nullable RateLimiter rateLimiter) {
        if (rateLimiter == null || rateLimiter == UNLIMITED || rateLimiter.tryAcquire()) {
            return this.push0(c, normalizing);
        }
        return CompletableFutures.exceptionallyCompletedFuture((Throwable)new TooManyRequestsException("commits", c.executionPath(), rateLimiter.getRate()));
    }

    private CompletableFuture<CommitResult> push0(RepositoryCommand<?> c, boolean normalizing) {
        if (c instanceof TransformCommand) {
            TransformCommand transformCommand = (TransformCommand)c;
            return this.repo(c).commit(transformCommand.baseRevision(), transformCommand.timestamp(), transformCommand.author(), transformCommand.summary(), transformCommand.detail(), transformCommand.markup(), transformCommand.transformer());
        }
        assert (c instanceof AbstractPushCommand);
        AbstractPushCommand pushCommand = (AbstractPushCommand)c;
        return this.repo(c).commit(pushCommand.baseRevision(), pushCommand.timestamp(), pushCommand.author(), pushCommand.summary(), pushCommand.detail(), pushCommand.markup(), pushCommand.changes(), normalizing);
    }

    private CompletableFuture<RateLimiter> getRateLimiter(String projectName, String repoName) {
        return this.metadataService.getRepo(projectName, repoName).thenApply(meta -> {
            this.setWriteQuota(projectName, repoName, meta.writeQuota());
            return this.writeRateLimiters.get(StandaloneCommandExecutor.rateLimiterKey(projectName, repoName));
        });
    }

    @Override
    public final void setWriteQuota(String projectName, String repoName, @Nullable QuotaConfig writeQuota) {
        if (!this.writeQuotaEnabled()) {
            return;
        }
        double permitsForRepo = writeQuota != null ? writeQuota.permitsPerSecond() : 0.0;
        double permitsPerSecond = permitsForRepo != 0.0 ? permitsForRepo : this.permitsPerSecond;
        this.writeRateLimiters.compute(StandaloneCommandExecutor.rateLimiterKey(projectName, repoName), (key, rateLimiter) -> {
            if (permitsPerSecond == 0.0) {
                return UNLIMITED;
            }
            if (rateLimiter == null) {
                return RateLimiter.create((double)permitsPerSecond);
            }
            rateLimiter.setRate(permitsPerSecond);
            return rateLimiter;
        });
    }

    private static String rateLimiterKey(String projectName, String repoName) {
        return projectName + '/' + repoName;
    }

    private boolean writeQuotaEnabled() {
        return Double.compare(this.permitsPerSecond, -1.0) > 0;
    }

    private Repository repo(RepositoryCommand<?> c) {
        return (Repository)((Project)this.projectManager.get(c.projectName())).repos().get(c.repositoryName());
    }

    private CompletableFuture<Void> createSession(CreateSessionCommand c) {
        if (this.sessionManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        Session session = c.session();
        return this.sessionManager.create(session).exceptionally(cause -> {
            logger.warn("Failed to replicate a session creation: {}", (Object)session, cause);
            return null;
        });
    }

    private CompletableFuture<Void> removeSession(RemoveSessionCommand c) {
        if (this.sessionManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        String sessionId = c.sessionId();
        return this.sessionManager.delete(sessionId).exceptionally(cause -> {
            logger.warn("Failed to replicate a session removal: {}", (Object)sessionId, cause);
            return null;
        });
    }

    private CompletableFuture<Void> updateServerStatus(UpdateServerStatusCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.serverStatusManager.updateStatus(c.serverStatus());
            this.statusManager().updateStatus(c);
            return null;
        }, this.serverStatusManager.sequentialExecutor());
    }
}

