/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Route;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;

public interface AuthProvider {
    public static final String LOGIN_PATH = "/link/auth/login";
    public static final String LOGOUT_PATH = "/link/auth/logout";
    public static final String BUILTIN_WEB_BASE_PATH = "/web/auth";
    public static final String BUILTIN_WEB_LOGIN_PATH = "/web/auth/login";
    public static final String BUILTIN_WEB_LOGOUT_PATH = "/web/auth/logout";
    public static final Set<Route> LOGIN_API_ROUTES = ImmutableSet.of((Object)Route.builder().exact("/api/v0/authenticate").build(), (Object)Route.builder().exact("/api/v1/login").build());
    public static final Set<Route> LOGOUT_API_ROUTES = ImmutableSet.of((Object)Route.builder().exact("/api/v0/logout").build(), (Object)Route.builder().exact("/api/v1/logout").build());

    default public HttpService webLoginService() {
        return (ctx, req) -> {
            String returnTo = ctx.queryParam("return_to");
            returnTo = returnTo != null ? returnTo + BUILTIN_WEB_LOGIN_PATH : BUILTIN_WEB_LOGIN_PATH;
            return HttpResponse.ofRedirect((HttpStatus)HttpStatus.MOVED_PERMANENTLY, (String)returnTo);
        };
    }

    default public HttpService webLogoutService() {
        return (ctx, req) -> {
            String returnTo = ctx.queryParam("return_to");
            returnTo = returnTo != null ? returnTo + BUILTIN_WEB_LOGOUT_PATH : BUILTIN_WEB_LOGOUT_PATH;
            return HttpResponse.ofRedirect((HttpStatus)HttpStatus.MOVED_PERMANENTLY, (String)returnTo);
        };
    }

    @Nullable
    default public HttpService loginApiService() {
        return null;
    }

    @Nullable
    default public HttpService logoutApiService() {
        return null;
    }

    default public Iterable<HttpServiceWithRoutes> moreServices() {
        return ImmutableList.of();
    }
}

