/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.CentralDogma;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.CorsConfig;
import com.linecorp.centraldogma.server.GracefulShutdownTimeout;
import com.linecorp.centraldogma.server.ManagementConfig;
import com.linecorp.centraldogma.server.QuotaConfig;
import com.linecorp.centraldogma.server.ReplicationConfig;
import com.linecorp.centraldogma.server.TlsConfig;
import com.linecorp.centraldogma.server.auth.AuthConfig;
import com.linecorp.centraldogma.server.auth.AuthProviderFactory;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginConfig;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CentralDogmaBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogmaBuilder.class);
    private static final ServerPort DEFAULT_PORT = new ServerPort(36462, new SessionProtocol[]{SessionProtocol.HTTP});
    static final int DEFAULT_NUM_REPOSITORY_WORKERS = 16;
    static final long DEFAULT_MAX_REMOVED_REPOSITORY_AGE_MILLIS = 604800000L;
    static final String DEFAULT_REPOSITORY_CACHE_SPEC = "maximumWeight=134217728,expireAfterAccess=5m";
    private final List<ServerPort> ports = new ArrayList<ServerPort>(2);
    @Nullable
    private TlsConfig tls;
    private final List<String> trustedProxyAddresses = new ArrayList<String>();
    private final List<String> clientAddressSources = new ArrayList<String>();
    @Nullable
    private Integer numWorkers;
    @Nullable
    private Integer maxNumConnections;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long idleTimeoutMillis;
    @Nullable
    private Integer maxFrameLength;
    private final File dataDir;
    private int numRepositoryWorkers = 16;
    private long maxRemovedRepositoryAgeMillis = 604800000L;
    @Nullable
    private String repositoryCacheSpec = "maximumWeight=134217728,expireAfterAccess=5m";
    private boolean webAppEnabled = true;
    @Nullable
    private String webAppTitle;
    @Nullable
    private GracefulShutdownTimeout gracefulShutdownTimeout;
    private ReplicationConfig replicationConfig = ReplicationConfig.NONE;
    @Nullable
    private String accessLogFormat;
    @Nullable
    private AuthProviderFactory authProviderFactory;
    private final ImmutableSet.Builder<String> administrators = new ImmutableSet.Builder();
    private boolean caseSensitiveLoginNames;
    private String sessionCacheSpec = "maximumSize=8192,expireAfterWrite=604800s";
    private long sessionTimeoutMillis = 604800000L;
    private String sessionValidationSchedule = "0 30 */4 ? * *";
    @Nullable
    private Object authProviderProperties;
    private int writeQuota;
    private int timeWindowSeconds;
    private MeterRegistry meterRegistry = Flags.meterRegistry();
    @Nullable
    private CorsConfig corsConfig;
    private final List<PluginConfig> pluginConfigs = new ArrayList<PluginConfig>();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    @Nullable
    private ManagementConfig managementConfig;
    @Nullable
    private String zone;

    public CentralDogmaBuilder(File dataDir) {
        this.dataDir = Objects.requireNonNull(dataDir, "dataDir");
        if (dataDir.exists() && !dataDir.isDirectory()) {
            throw new IllegalArgumentException("dataDir: " + dataDir + " (not a directory)");
        }
    }

    public CentralDogmaBuilder port(int port, SessionProtocol protocol) {
        return this.port(new ServerPort(port, new SessionProtocol[]{protocol}));
    }

    public CentralDogmaBuilder port(InetSocketAddress localAddress, SessionProtocol protocol) {
        return this.port(new ServerPort(localAddress, new SessionProtocol[]{protocol}));
    }

    public CentralDogmaBuilder port(ServerPort port) {
        this.ports.add(Objects.requireNonNull(port, "port"));
        return this;
    }

    public CentralDogmaBuilder tls(TlsConfig tls) {
        this.tls = Objects.requireNonNull(tls, "tls");
        return this;
    }

    public CentralDogmaBuilder trustedProxyAddresses(String ... exactOrCidrAddresses) {
        Objects.requireNonNull(exactOrCidrAddresses, "exactOrCidrAddresses");
        this.trustedProxyAddresses.addAll((Collection<String>)ImmutableList.copyOf((Object[])exactOrCidrAddresses));
        return this;
    }

    public CentralDogmaBuilder trustedProxyAddresses(Iterable<String> exactOrCidrAddresses) {
        Objects.requireNonNull(exactOrCidrAddresses, "exactOrCidrAddresses");
        this.trustedProxyAddresses.addAll((Collection<String>)ImmutableList.copyOf(exactOrCidrAddresses));
        return this;
    }

    public CentralDogmaBuilder clientAddressSources(String ... clientAddressSources) {
        Objects.requireNonNull(clientAddressSources, "clientAddressSources");
        this.clientAddressSources.addAll((Collection<String>)ImmutableList.copyOf((Object[])clientAddressSources));
        return this;
    }

    public CentralDogmaBuilder clientAddressSources(Iterable<String> clientAddressSources) {
        Objects.requireNonNull(clientAddressSources, "clientAddressSources");
        this.clientAddressSources.addAll((Collection<String>)ImmutableList.copyOf(clientAddressSources));
        return this;
    }

    public CentralDogmaBuilder numWorkers(int numWorkers) {
        this.numWorkers = numWorkers;
        return this;
    }

    public CentralDogmaBuilder maxNumConnections(int maxNumConnections) {
        this.maxNumConnections = maxNumConnections;
        return this;
    }

    public CentralDogmaBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    public CentralDogmaBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
        return this;
    }

    public CentralDogmaBuilder idleTimeout(Duration idleTimeout) {
        return this.idleTimeoutMillis(Objects.requireNonNull(idleTimeout, "idleTimeout").toMillis());
    }

    public CentralDogmaBuilder idleTimeoutMillis(long idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
        return this;
    }

    public CentralDogmaBuilder maxFrameLength(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
        return this;
    }

    public CentralDogmaBuilder numRepositoryWorkers(int numRepositoryWorkers) {
        this.numRepositoryWorkers = numRepositoryWorkers;
        return this;
    }

    public CentralDogmaBuilder maxRemovedRepositoryAge(Duration maxRemovedRepositoryAge) {
        this.maxRemovedRepositoryAgeMillis(Objects.requireNonNull(maxRemovedRepositoryAge, "maxRemovedRepositoryAge").toMillis());
        return this;
    }

    public CentralDogmaBuilder maxRemovedRepositoryAgeMillis(long maxRemovedRepositoryAgeMillis) {
        this.maxRemovedRepositoryAgeMillis = maxRemovedRepositoryAgeMillis;
        return this;
    }

    @Deprecated
    public CentralDogmaBuilder cacheSpec(String cacheSpec) {
        this.repositoryCacheSpec = RepositoryCache.validateCacheSpec(cacheSpec);
        return this;
    }

    public CentralDogmaBuilder repositoryCacheSpec(String repositoryCacheSpec) {
        this.repositoryCacheSpec = RepositoryCache.validateCacheSpec(repositoryCacheSpec);
        return this;
    }

    public CentralDogmaBuilder webAppEnabled(boolean webAppEnabled) {
        this.webAppEnabled = webAppEnabled;
        return this;
    }

    public CentralDogmaBuilder webAppTitle(String webAppTitle) {
        this.webAppTitle = Objects.requireNonNull(webAppTitle, "webAppTitle");
        return this;
    }

    public CentralDogmaBuilder gracefulShutdownTimeout(GracefulShutdownTimeout gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        return this;
    }

    public CentralDogmaBuilder replication(ReplicationConfig replicationConfig) {
        this.replicationConfig = Objects.requireNonNull(replicationConfig, "replicationConfig");
        return this;
    }

    public CentralDogmaBuilder accessLogFormat(String accessLogFormat) {
        this.accessLogFormat = Objects.requireNonNull(accessLogFormat, "accessLogFormat");
        return this;
    }

    public CentralDogmaBuilder authProviderFactory(AuthProviderFactory authProviderFactory) {
        this.authProviderFactory = Objects.requireNonNull(authProviderFactory, "authProviderFactory");
        return this;
    }

    public CentralDogmaBuilder administrators(String ... administrators) {
        Objects.requireNonNull(administrators, "administrators");
        for (String administrator : administrators) {
            this.administrators.add((Object)administrator);
        }
        return this;
    }

    public CentralDogmaBuilder administrators(Iterable<String> administrators) {
        Objects.requireNonNull(administrators, "administrators");
        this.administrators.addAll(administrators);
        return this;
    }

    public CentralDogmaBuilder caseSensitiveLoginNames(boolean caseSensitiveLoginNames) {
        this.caseSensitiveLoginNames = caseSensitiveLoginNames;
        return this;
    }

    public CentralDogmaBuilder sessionCacheSpec(String sessionCacheSpec) {
        this.sessionCacheSpec = RepositoryCache.validateCacheSpec(sessionCacheSpec);
        return this;
    }

    public CentralDogmaBuilder sessionTimeoutMillis(long sessionTimeoutMillis) {
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        return this;
    }

    public CentralDogmaBuilder sessionTimeout(Duration sessionTimeout) {
        return this.sessionTimeoutMillis(Objects.requireNonNull(sessionTimeout, "sessionTimeout").toMillis());
    }

    public CentralDogmaBuilder sessionValidationSchedule(String sessionValidationSchedule) {
        this.sessionValidationSchedule = Objects.requireNonNull(sessionValidationSchedule, "sessionValidationSchedule");
        return this;
    }

    public CentralDogmaBuilder authProviderProperties(Object authProviderProperties) {
        this.authProviderProperties = Objects.requireNonNull(authProviderProperties, "authProviderProperties");
        return this;
    }

    public CentralDogmaBuilder writeQuotaPerRepository(int writeQuota, int timeWindowSeconds) {
        Preconditions.checkArgument((writeQuota > 0 ? 1 : 0) != 0, (String)"writeQuota: %s (expected: > 0)", (int)writeQuota);
        Preconditions.checkArgument((timeWindowSeconds > 0 ? 1 : 0) != 0, (String)"timeWindowSeconds: %s (expected: > 0)", (int)timeWindowSeconds);
        this.writeQuota = writeQuota;
        this.timeWindowSeconds = timeWindowSeconds;
        return this;
    }

    public CentralDogmaBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        return this;
    }

    public CentralDogmaBuilder cors(String ... allowedOrigins) {
        Objects.requireNonNull(allowedOrigins, "allowedOrigins");
        this.corsConfig = new CorsConfig(ImmutableList.copyOf((Object[])allowedOrigins), null);
        return this;
    }

    public CentralDogmaBuilder cors(CorsConfig corsConfig) {
        this.corsConfig = Objects.requireNonNull(corsConfig, "corsConfig");
        return this;
    }

    public CentralDogmaBuilder pluginConfigs(PluginConfig ... pluginConfigs) {
        Objects.requireNonNull(pluginConfigs, "pluginConfigs");
        this.pluginConfigs.addAll((Collection<PluginConfig>)ImmutableList.copyOf((Object[])pluginConfigs));
        return this;
    }

    public CentralDogmaBuilder plugins(Plugin ... plugins) {
        Objects.requireNonNull(plugins, "plugins");
        return this.plugins((Iterable<? extends Plugin>)ImmutableList.copyOf((Object[])plugins));
    }

    public CentralDogmaBuilder plugins(Iterable<? extends Plugin> plugins) {
        Objects.requireNonNull(plugins, "plugins");
        this.plugins.addAll((Collection<Plugin>)ImmutableList.copyOf(plugins));
        return this;
    }

    public CentralDogmaBuilder management(ManagementConfig managementConfig) {
        Objects.requireNonNull(managementConfig, "managementConfig");
        this.managementConfig = managementConfig;
        return this;
    }

    public CentralDogmaBuilder zone(String zone) {
        Objects.requireNonNull(zone, "zone");
        this.zone = zone;
        return this;
    }

    public CentralDogma build() {
        return new CentralDogma(this.buildConfig(), this.meterRegistry, (List<Plugin>)ImmutableList.copyOf(this.plugins));
    }

    private CentralDogmaConfig buildConfig() {
        AuthConfig authCfg;
        List<ServerPort> ports = !this.ports.isEmpty() ? this.ports : Collections.singletonList(DEFAULT_PORT);
        ImmutableSet adminSet = this.administrators.build();
        if (this.authProviderFactory != null) {
            authCfg = new AuthConfig(this.authProviderFactory, (Set<String>)adminSet, this.caseSensitiveLoginNames, this.sessionCacheSpec, this.sessionTimeoutMillis, this.sessionValidationSchedule, this.authProviderProperties != null ? Jackson.valueToTree((Object)this.authProviderProperties) : null);
        } else {
            authCfg = null;
            logger.info("{} is not specified, so {} will not be configured.", (Object)AuthProviderFactory.class.getSimpleName(), (Object)AuthConfig.class.getSimpleName());
        }
        QuotaConfig quotaConfig = this.writeQuota > 0 ? new QuotaConfig(this.writeQuota, this.timeWindowSeconds) : null;
        return new CentralDogmaConfig(this.dataDir, ports, this.tls, this.trustedProxyAddresses, this.clientAddressSources, this.numWorkers, this.maxNumConnections, this.requestTimeoutMillis, this.idleTimeoutMillis, this.maxFrameLength, this.numRepositoryWorkers, this.repositoryCacheSpec, this.maxRemovedRepositoryAgeMillis, this.gracefulShutdownTimeout, this.webAppEnabled, this.webAppTitle, this.replicationConfig, null, this.accessLogFormat, authCfg, quotaConfig, this.corsConfig, this.pluginConfigs, this.managementConfig, this.zone);
    }
}

