/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.common.prometheus.PrometheusMeterRegistries;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.StartStopSupport;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.ReflectiveDependencyInjector;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.AnnotatedServiceBindingBuilder;
import com.linecorp.armeria.server.ContextPathAnnotatedServiceConfigSetters;
import com.linecorp.armeria.server.ContextPathServicesBuilder;
import com.linecorp.armeria.server.DecoratingServiceBindingBuilder;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServiceBindingBuilder;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.VirtualHostServiceBindingBuilder;
import com.linecorp.armeria.server.annotation.JacksonRequestConverterFunction;
import com.linecorp.armeria.server.auth.AuthFailureHandler;
import com.linecorp.armeria.server.auth.AuthService;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.encoding.DecodingService;
import com.linecorp.armeria.server.encoding.EncodingService;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.SettableHealthChecker;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import com.linecorp.armeria.server.management.ManagementService;
import com.linecorp.armeria.server.metric.MetricCollectingService;
import com.linecorp.armeria.server.prometheus.PrometheusExpositionService;
import com.linecorp.armeria.server.thrift.THttpService;
import com.linecorp.armeria.server.thrift.ThriftCallService;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaService;
import com.linecorp.centraldogma.server.CacheStatsSerializer;
import com.linecorp.centraldogma.server.CentralDogmaAuthFailureHandler;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.CorsConfig;
import com.linecorp.centraldogma.server.GracefulShutdownTimeout;
import com.linecorp.centraldogma.server.ManagementConfig;
import com.linecorp.centraldogma.server.MirroringService;
import com.linecorp.centraldogma.server.PluginGroup;
import com.linecorp.centraldogma.server.ReplicationMethod;
import com.linecorp.centraldogma.server.TlsConfig;
import com.linecorp.centraldogma.server.ZooKeeperReplicationConfig;
import com.linecorp.centraldogma.server.auth.AuthConfig;
import com.linecorp.centraldogma.server.auth.AuthProvider;
import com.linecorp.centraldogma.server.auth.AuthProviderParameters;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.StandaloneCommandExecutor;
import com.linecorp.centraldogma.server.internal.admin.auth.CachedSessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.CsrfTokenAuthorizer;
import com.linecorp.centraldogma.server.internal.admin.auth.ExpiredSessionDeletingSessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.FileBasedSessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionTokenAuthorizer;
import com.linecorp.centraldogma.server.internal.admin.service.DefaultLogoutService;
import com.linecorp.centraldogma.server.internal.admin.service.RepositoryService;
import com.linecorp.centraldogma.server.internal.admin.service.UserService;
import com.linecorp.centraldogma.server.internal.api.AdministrativeService;
import com.linecorp.centraldogma.server.internal.api.ContentServiceV1;
import com.linecorp.centraldogma.server.internal.api.CredentialServiceV1;
import com.linecorp.centraldogma.server.internal.api.GitHttpService;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.MetadataApiService;
import com.linecorp.centraldogma.server.internal.api.MirroringServiceV1;
import com.linecorp.centraldogma.server.internal.api.ProjectServiceV1;
import com.linecorp.centraldogma.server.internal.api.RepositoryServiceV1;
import com.linecorp.centraldogma.server.internal.api.TokenService;
import com.linecorp.centraldogma.server.internal.api.WatchService;
import com.linecorp.centraldogma.server.internal.api.auth.ApplicationTokenAuthorizer;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresPermissionDecorator;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRoleDecorator;
import com.linecorp.centraldogma.server.internal.api.converter.HttpApiRequestConverter;
import com.linecorp.centraldogma.server.internal.mirror.DefaultMirroringServicePlugin;
import com.linecorp.centraldogma.server.internal.mirror.MirrorRunner;
import com.linecorp.centraldogma.server.internal.replication.ZooKeeperCommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.project.DefaultProjectManager;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.internal.storage.repository.MirrorConfig;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaExceptionTranslator;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaServiceImpl;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaTimeoutScheduler;
import com.linecorp.centraldogma.server.internal.thrift.TokenlessClientLogger;
import com.linecorp.centraldogma.server.management.ServerStatus;
import com.linecorp.centraldogma.server.management.ServerStatusManager;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.mirror.MirrorProvider;
import com.linecorp.centraldogma.server.plugin.AllReplicasPlugin;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginInitContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import com.linecorp.centraldogma.server.storage.project.InternalProjectInitializer;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.DiskSpaceMetrics;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralDogma
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogma.class);
    private static final boolean GIT_MIRROR_ENABLED;
    private final SettableHealthChecker serverHealth = new SettableHealthChecker(false);
    private final CentralDogmaStartStop startStop;
    private final AtomicInteger numPendingStopRequests = new AtomicInteger();
    @Nullable
    private final PluginGroup pluginsForAllReplicas;
    @Nullable
    private final PluginGroup pluginsForLeaderOnly;
    @Nullable
    private final PluginGroup pluginsForZoneLeaderOnly;
    private final CentralDogmaConfig cfg;
    @Nullable
    private volatile ProjectManager pm;
    @Nullable
    private volatile Server server;
    @Nullable
    private ExecutorService repositoryWorker;
    @Nullable
    private ScheduledExecutorService purgeWorker;
    @Nullable
    private CommandExecutor executor;
    private final MeterRegistry meterRegistry;
    @Nullable
    MeterRegistry meterRegistryToBeClosed;
    @Nullable
    private SessionManager sessionManager;
    @Nullable
    private ServerStatusManager statusManager;
    @Nullable
    private InternalProjectInitializer projectInitializer;
    @Nullable
    private volatile MirrorRunner mirrorRunner;

    public static CentralDogma forConfig(File configFile) throws IOException {
        Objects.requireNonNull(configFile, "configFile");
        return new CentralDogma(CentralDogmaConfig.load(configFile), Flags.meterRegistry(), (List<Plugin>)ImmutableList.of());
    }

    CentralDogma(CentralDogmaConfig cfg, MeterRegistry meterRegistry, List<Plugin> plugins) {
        this.cfg = Objects.requireNonNull(cfg, "cfg");
        this.pluginsForAllReplicas = PluginGroup.loadPlugins(CentralDogma.class.getClassLoader(), PluginTarget.ALL_REPLICAS, cfg, plugins);
        this.pluginsForLeaderOnly = PluginGroup.loadPlugins(CentralDogma.class.getClassLoader(), PluginTarget.LEADER_ONLY, cfg, plugins);
        this.pluginsForZoneLeaderOnly = PluginGroup.loadPlugins(CentralDogma.class.getClassLoader(), PluginTarget.ZONE_LEADER_ONLY, cfg, plugins);
        if (this.pluginsForZoneLeaderOnly != null) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)cfg.zone()) ? 1 : 0) != 0, (Object)"zone must be specified when zone leader plugins are enabled.");
        }
        this.startStop = new CentralDogmaStartStop(this.pluginsForAllReplicas);
        this.meterRegistry = meterRegistry;
    }

    public CentralDogmaConfig config() {
        return this.cfg;
    }

    @Nullable
    public ServerPort activePort() {
        Server server = this.server;
        return server != null ? server.activePort() : null;
    }

    public Map<InetSocketAddress, ServerPort> activePorts() {
        Server server = this.server;
        if (server != null) {
            return server.activePorts();
        }
        return Collections.emptyMap();
    }

    @Nullable
    public ProjectManager projectManager() {
        return this.pm;
    }

    public Optional<MirroringService> mirroringService() {
        if (this.pluginsForLeaderOnly == null) {
            return Optional.empty();
        }
        return this.pluginsForLeaderOnly.findFirstPlugin(DefaultMirroringServicePlugin.class).map(DefaultMirroringServicePlugin::mirroringService);
    }

    public List<Plugin> plugins(PluginTarget target) {
        switch (Objects.requireNonNull(target, "target")) {
            case LEADER_ONLY: {
                return this.pluginsForLeaderOnly != null ? ImmutableList.copyOf(this.pluginsForLeaderOnly.plugins()) : ImmutableList.of();
            }
            case ALL_REPLICAS: {
                return this.pluginsForAllReplicas != null ? ImmutableList.copyOf(this.pluginsForAllReplicas.plugins()) : ImmutableList.of();
            }
            case ZONE_LEADER_ONLY: {
                return this.pluginsForZoneLeaderOnly != null ? ImmutableList.copyOf(this.pluginsForZoneLeaderOnly.plugins()) : ImmutableList.of();
            }
        }
        throw new Error("Unknown plugin target: " + (Object)((Object)target));
    }

    public Optional<MeterRegistry> meterRegistry() {
        return Optional.ofNullable(this.meterRegistry);
    }

    public CompletableFuture<Void> start() {
        return this.startStop.start(true);
    }

    public CompletableFuture<Void> stop() {
        this.serverHealth.setHealthy(false);
        Optional<GracefulShutdownTimeout> gracefulTimeoutOpt = this.cfg.gracefulShutdownTimeout();
        if (gracefulTimeoutOpt.isPresent()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted while waiting for quiet period", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.numPendingStopRequests.incrementAndGet();
        return this.startStop.stop().thenRun(this.numPendingStopRequests::decrementAndGet);
    }

    @Override
    public void close() {
        this.startStop.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() throws Exception {
        block7: {
            SessionManager sessionManager;
            Server server;
            CommandExecutor executor;
            DefaultProjectManager pm;
            ScheduledExecutorService purgeWorker;
            ExecutorService repositoryWorker;
            block6: {
                boolean success = false;
                repositoryWorker = null;
                purgeWorker = null;
                pm = null;
                executor = null;
                server = null;
                sessionManager = null;
                try {
                    logger.info("Starting the Central Dogma ..");
                    ThreadPoolExecutor repositoryWorkerImpl = new ThreadPoolExecutor(this.cfg.numRepositoryWorkers(), this.cfg.numRepositoryWorkers(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("repository-worker", true));
                    repositoryWorkerImpl.allowCoreThreadTimeOut(true);
                    repositoryWorker = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)repositoryWorkerImpl, (String)"repositoryWorker", (Tag[])new Tag[0]);
                    logger.info("Starting the project manager: {}", (Object)this.cfg.dataDir());
                    purgeWorker = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("purge-worker", true));
                    pm = new DefaultProjectManager(this.cfg.dataDir(), repositoryWorker, purgeWorker, this.meterRegistry, this.cfg.repositoryCacheSpec());
                    logger.info("Started the project manager: {}", (Object)pm);
                    logger.info("Current settings:\n{}", (Object)this.cfg);
                    sessionManager = this.initializeSessionManager();
                    logger.info("Starting the command executor ..");
                    executor = this.startCommandExecutor(pm, repositoryWorker, purgeWorker, this.meterRegistry, sessionManager);
                    assert (this.projectInitializer != null);
                    if (executor.isWritable()) {
                        logger.info("Started the command executor.");
                    }
                    logger.info("Starting the RPC server.");
                    server = this.startServer(pm, executor, purgeWorker, this.meterRegistry, sessionManager, this.projectInitializer);
                    logger.info("Started the RPC server at: {}", (Object)server.activePorts());
                    logger.info("Started the Central Dogma successfully.");
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        this.serverHealth.setHealthy(true);
                        this.repositoryWorker = repositoryWorker;
                        this.purgeWorker = purgeWorker;
                        this.pm = pm;
                        this.executor = executor;
                        this.server = server;
                        this.sessionManager = sessionManager;
                    } else {
                        CentralDogma.doStop(server, executor, pm, repositoryWorker, purgeWorker, sessionManager, this.mirrorRunner);
                    }
                    throw throwable;
                }
                this.serverHealth.setHealthy(true);
                this.repositoryWorker = repositoryWorker;
                this.purgeWorker = purgeWorker;
                this.pm = pm;
                this.executor = executor;
                this.server = server;
                this.sessionManager = sessionManager;
                break block7;
            }
            CentralDogma.doStop(server, executor, pm, repositoryWorker, purgeWorker, sessionManager, this.mirrorRunner);
        }
    }

    private CommandExecutor startCommandExecutor(ProjectManager pm, Executor repositoryWorker, ScheduledExecutorService purgeWorker, MeterRegistry meterRegistry, @Nullable SessionManager sessionManager) {
        CommandExecutor executor;
        Consumer<CommandExecutor> onTakeLeadership = exec -> {
            if (this.pluginsForLeaderOnly != null) {
                logger.info("Starting plugins on the leader replica ..");
                this.pluginsForLeaderOnly.start(this.cfg, pm, (CommandExecutor)exec, meterRegistry, purgeWorker, this.projectInitializer).handle((unused, cause) -> {
                    if (cause == null) {
                        logger.info("Started plugins on the leader replica.");
                    } else {
                        logger.error("Failed to start plugins on the leader replica..", cause);
                    }
                    return null;
                });
            }
        };
        Consumer<CommandExecutor> onReleaseLeadership = exec -> {
            if (this.pluginsForLeaderOnly != null) {
                logger.info("Stopping plugins on the leader replica ..");
                this.pluginsForLeaderOnly.stop(this.cfg, pm, (CommandExecutor)exec, meterRegistry, purgeWorker, this.projectInitializer).handle((unused, cause) -> {
                    if (cause == null) {
                        logger.info("Stopped plugins on the leader replica.");
                    } else {
                        logger.error("Failed to stop plugins on the leader replica.", cause);
                    }
                    return null;
                });
            }
        };
        Consumer<CommandExecutor> onTakeZoneLeadership = null;
        Consumer<CommandExecutor> onReleaseZoneLeadership = null;
        if (this.pluginsForZoneLeaderOnly != null) {
            String zone = this.cfg.zone();
            onTakeZoneLeadership = exec -> {
                logger.info("Starting plugins on the {} zone leader replica ..", (Object)zone);
                this.pluginsForZoneLeaderOnly.start(this.cfg, pm, (CommandExecutor)exec, meterRegistry, purgeWorker, this.projectInitializer).handle((unused, cause) -> {
                    if (cause == null) {
                        logger.info("Started plugins on the {} zone leader replica.", (Object)zone);
                    } else {
                        logger.error("Failed to start plugins on the {} zone leader replica..", (Object)zone, cause);
                    }
                    return null;
                });
            };
            onReleaseZoneLeadership = exec -> {
                logger.info("Stopping plugins on the {} zone leader replica ..", (Object)zone);
                this.pluginsForZoneLeaderOnly.stop(this.cfg, pm, (CommandExecutor)exec, meterRegistry, purgeWorker, this.projectInitializer).handle((unused, cause) -> {
                    if (cause == null) {
                        logger.info("Stopped plugins on the {} zone leader replica.", (Object)zone);
                    } else {
                        logger.error("Failed to stop plugins on the {} zone leader replica.", (Object)zone, cause);
                    }
                    return null;
                });
            };
        }
        this.statusManager = new ServerStatusManager(this.cfg.dataDir());
        logger.info("Startup mode: {}", (Object)this.statusManager.serverStatus());
        ReplicationMethod replicationMethod = this.cfg.replicationConfig().method();
        switch (replicationMethod) {
            case ZOOKEEPER: {
                executor = this.newZooKeeperCommandExecutor(pm, repositoryWorker, this.statusManager, meterRegistry, sessionManager, onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
                break;
            }
            case NONE: {
                logger.info("No replication mechanism specified; entering standalone");
                executor = new StandaloneCommandExecutor(pm, repositoryWorker, this.statusManager, sessionManager, this.cfg.writeQuotaPerRepository(), onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
                break;
            }
            default: {
                throw new Error("unknown replication method: " + (Object)((Object)replicationMethod));
            }
        }
        this.projectInitializer = new InternalProjectInitializer(executor, pm);
        ServerStatus initialServerStatus = this.statusManager.serverStatus();
        executor.setWritable(initialServerStatus.writable());
        if (!initialServerStatus.replicating()) {
            this.projectInitializer.whenInitialized().complete(null);
            return executor;
        }
        try {
            CompletableFuture<Void> startFuture = executor.start();
            while (!startFuture.isDone()) {
                if (this.numPendingStopRequests.get() > 0) {
                    executor.stop().get();
                    break;
                }
                try {
                    startFuture.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {}
            }
            startFuture.get();
            this.projectInitializer.initialize();
        }
        catch (Exception e) {
            this.projectInitializer.whenInitialized().complete(null);
            logger.warn("Failed to start the command executor. Entering read-only.", (Throwable)e);
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SessionManager initializeSessionManager() throws Exception {
        AuthConfig authCfg = this.cfg.authConfig();
        if (authCfg == null) {
            return null;
        }
        boolean success = false;
        AutoCloseable manager = null;
        try {
            manager = new FileBasedSessionManager(new File(this.cfg.dataDir(), "_sessions").toPath(), authCfg.sessionValidationSchedule());
            manager = new CachedSessionManager((SessionManager)manager, (Cache<String, Session>)Caffeine.from((String)authCfg.sessionCacheSpec()).build());
            manager = new ExpiredSessionDeletingSessionManager((SessionManager)manager);
            success = true;
            AutoCloseable autoCloseable = manager;
            return autoCloseable;
        }
        finally {
            if (!success && manager != null) {
                try {
                    manager.close();
                }
                catch (Exception e) {
                    logger.warn("Failed to close a session manager.", (Throwable)e);
                }
            }
        }
    }

    private Server startServer(ProjectManager pm, CommandExecutor executor, ScheduledExecutorService purgeWorker, MeterRegistry meterRegistry, @Nullable SessionManager sessionManager, InternalProjectInitializer projectInitializer) {
        ServerBuilder sb;
        block23: {
            boolean needsTls;
            sb = Server.builder();
            this.cfg.ports().forEach(arg_0 -> ((ServerBuilder)sb).port(arg_0));
            boolean bl = needsTls = this.cfg.ports().stream().anyMatch(ServerPort::hasTls) || this.cfg.managementConfig() != null && this.cfg.managementConfig().protocol().isTls();
            if (needsTls) {
                try {
                    TlsConfig tlsConfig = this.cfg.tls();
                    if (tlsConfig != null) {
                        try (InputStream keyCertChainInputStream = tlsConfig.keyCertChainInputStream();
                             InputStream keyInputStream = tlsConfig.keyInputStream();){
                            sb.tls(keyCertChainInputStream, keyInputStream, tlsConfig.keyPassword());
                            break block23;
                        }
                    }
                    logger.warn("Missing TLS configuration. Generating a self-signed certificate for TLS support.");
                    sb.tlsSelfSigned();
                }
                catch (Exception e2) {
                    Exceptions.throwUnsafely((Throwable)e2);
                }
            }
        }
        sb.clientAddressSources(this.cfg.clientAddressSourceList());
        sb.clientAddressTrustedProxyFilter(this.cfg.trustedProxyAddressPredicate());
        this.cfg.numWorkers().ifPresent(numWorkers -> sb.workerGroup(EventLoopGroups.newEventLoopGroup((int)numWorkers), true));
        this.cfg.maxNumConnections().ifPresent(arg_0 -> ((ServerBuilder)sb).maxNumConnections(arg_0));
        this.cfg.idleTimeoutMillis().ifPresent(arg_0 -> ((ServerBuilder)sb).idleTimeoutMillis(arg_0));
        this.cfg.requestTimeoutMillis().ifPresent(arg_0 -> ((ServerBuilder)sb).requestTimeoutMillis(arg_0));
        this.cfg.maxFrameLength().ifPresent(arg_0 -> ((ServerBuilder)sb).maxRequestLength(arg_0));
        this.cfg.gracefulShutdownTimeout().ifPresent(t -> sb.gracefulShutdownTimeoutMillis(t.quietPeriodMillis(), t.timeoutMillis()));
        MetadataService mds = new MetadataService(pm, executor);
        WatchService watchService = new WatchService(meterRegistry);
        AuthProvider authProvider = this.createAuthProvider(executor, sessionManager, mds);
        ProjectApiManager projectApiManager = new ProjectApiManager(pm, executor, mds);
        this.configureThriftService(sb, projectApiManager, executor, watchService, mds);
        sb.service("/title", CentralDogma.webAppTitleFile(this.cfg.webAppTitle(), SystemInfo.hostname()).asService());
        sb.service("/monitor/l7check", (HttpService)HealthCheckService.builder().checkers(new HealthChecker[]{this.serverHealth}).build());
        CentralDogma.configManagement(sb, this.config().managementConfig());
        sb.serviceUnder("/docs/", (HttpService)DocService.builder().exampleHeaders(CentralDogmaService.class, new HttpHeaders[]{HttpHeaders.of((CharSequence)HttpHeaderNames.AUTHORIZATION, (String)"Bearer anonymous")}).build());
        Function<? super HttpService, AuthService> authService = this.authService(mds, authProvider, sessionManager);
        this.configureHttpApi(sb, projectApiManager, executor, watchService, mds, authProvider, authService, meterRegistry);
        this.configureMetrics(sb, meterRegistry);
        CentralDogma.configCors(sb, this.config().corsConfig());
        String accessLogFormat = this.cfg.accessLogFormat();
        if (Strings.isNullOrEmpty((String)accessLogFormat)) {
            sb.accessLogWriter(AccessLogWriter.disabled(), true);
        } else if ("common".equals(accessLogFormat)) {
            sb.accessLogWriter(AccessLogWriter.common(), true);
        } else if ("combined".equals(accessLogFormat)) {
            sb.accessLogWriter(AccessLogWriter.combined(), true);
        } else {
            sb.accessLogFormat(accessLogFormat);
        }
        if (this.pluginsForAllReplicas != null) {
            PluginInitContext pluginInitContext = new PluginInitContext(this.config(), pm, executor, meterRegistry, purgeWorker, sb, authService, projectInitializer);
            this.pluginsForAllReplicas.plugins().forEach(p -> {
                if (!(p instanceof AllReplicasPlugin)) {
                    return;
                }
                AllReplicasPlugin plugin = (AllReplicasPlugin)p;
                plugin.init(pluginInitContext);
            });
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.warn("Uncaught exception: {}", (Object)t, (Object)e));
        Server s = sb.build();
        s.start().join();
        return s;
    }

    static HttpFile webAppTitleFile(@Nullable String webAppTitle, String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        ImmutableMap titleAndHostname = ImmutableMap.of((Object)"title", (Object)((String)MoreObjects.firstNonNull((Object)webAppTitle, (Object)"Central Dogma at {{hostname}}")), (Object)"hostname", (Object)hostname);
        try {
            HttpData data = HttpData.ofUtf8((String)Jackson.writeValueAsString((Object)titleAndHostname));
            return HttpFile.builder((HttpData)data).contentType(MediaType.JSON_UTF_8).cacheControl((CacheControl)ServerCacheControl.REVALIDATED).build();
        }
        catch (JsonProcessingException e) {
            throw new Error("Failed to encode the title and hostname:", e);
        }
    }

    @Nullable
    private AuthProvider createAuthProvider(CommandExecutor commandExecutor, @Nullable SessionManager sessionManager, MetadataService mds) {
        AuthConfig authCfg = this.cfg.authConfig();
        if (authCfg == null) {
            return null;
        }
        Preconditions.checkState((sessionManager != null ? 1 : 0) != 0, (Object)"SessionManager is null");
        AuthProviderParameters parameters = new AuthProviderParameters((Authorizer<HttpRequest>)new ApplicationTokenAuthorizer(mds::findTokenBySecret).orElse(new SessionTokenAuthorizer(sessionManager, authCfg.administrators())), this.cfg, sessionManager::generateSessionId, session -> commandExecutor.execute(Command.createSession(session)), sessionId -> commandExecutor.execute(Command.removeSession(sessionId)));
        return authCfg.factory().create(parameters);
    }

    private CommandExecutor newZooKeeperCommandExecutor(ProjectManager pm, Executor repositoryWorker, ServerStatusManager serverStatusManager, MeterRegistry meterRegistry, @Nullable SessionManager sessionManager, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership, @Nullable Consumer<CommandExecutor> onTakeZoneLeadership, @Nullable Consumer<CommandExecutor> onReleaseZoneLeadership) {
        ZooKeeperReplicationConfig zkCfg = (ZooKeeperReplicationConfig)this.cfg.replicationConfig();
        File dataDir = this.cfg.dataDir();
        new File(dataDir, "replica_id").delete();
        return new ZooKeeperCommandExecutor(zkCfg, dataDir, new StandaloneCommandExecutor(pm, repositoryWorker, serverStatusManager, sessionManager, null, null, null, null), meterRegistry, pm, this.config().writeQuotaPerRepository(), this.config().zone(), onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
    }

    private void configureThriftService(ServerBuilder sb, ProjectApiManager projectApiManager, CommandExecutor executor, WatchService watchService, MetadataService mds) {
        CentralDogmaServiceImpl service = new CentralDogmaServiceImpl(projectApiManager, executor, watchService, mds);
        HttpService thriftService = (HttpService)((CentralDogmaExceptionTranslator)((CentralDogmaTimeoutScheduler)ThriftCallService.of((Object)service).decorate(CentralDogmaTimeoutScheduler::new)).decorate(CentralDogmaExceptionTranslator::new)).decorate(THttpService.newDecorator());
        thriftService = this.cfg.isCsrfTokenRequiredForThrift() ? (HttpService)thriftService.decorate(AuthService.newDecorator((Authorizer[])new Authorizer[]{new CsrfTokenAuthorizer()})) : (HttpService)thriftService.decorate(TokenlessClientLogger::new);
        thriftService = (HttpService)thriftService.decorate(CentralDogma.contentEncodingDecorator());
        sb.service("/cd/thrift/v1", thriftService);
    }

    private Function<? super HttpService, AuthService> authService(MetadataService mds, @Nullable AuthProvider authProvider, @Nullable SessionManager sessionManager) {
        if (authProvider == null) {
            return AuthService.newDecorator((Authorizer[])new Authorizer[]{new CsrfTokenAuthorizer()});
        }
        AuthConfig authCfg = this.cfg.authConfig();
        assert (authCfg != null) : "authCfg";
        assert (sessionManager != null) : "sessionManager";
        Authorizer tokenAuthorizer = new ApplicationTokenAuthorizer(mds::findTokenBySecret).orElse(new SessionTokenAuthorizer(sessionManager, authCfg.administrators()));
        return AuthService.builder().add(tokenAuthorizer).onFailure((AuthFailureHandler)new CentralDogmaAuthFailureHandler()).newDecorator();
    }

    private void configureHttpApi(ServerBuilder sb, ProjectApiManager projectApiManager, CommandExecutor executor, WatchService watchService, MetadataService mds, @Nullable AuthProvider authProvider, Function<? super HttpService, AuthService> authService, MeterRegistry meterRegistry) {
        DependencyInjector dependencyInjector = DependencyInjector.ofSingletons((Object[])new Object[]{new JacksonRequestConverterFunction(new ObjectMapper()), new HttpApiRequestConverter(projectApiManager), new RequiresPermissionDecorator.RequiresReadPermissionDecoratorFactory(mds), new RequiresPermissionDecorator.RequiresWritePermissionDecoratorFactory(mds), new RequiresRoleDecorator.RequiresRoleDecoratorFactory(mds)});
        sb.dependencyInjector(dependencyInjector, false).dependencyInjector((DependencyInjector)new ReflectiveDependencyInjector(), false);
        Function<? super HttpService, EncodingService> decorator = authService.andThen(CentralDogma.contentEncodingDecorator());
        for (String path : ImmutableList.of((Object)"/api/v0/", (Object)"/api/v1/")) {
            DecoratingServiceBindingBuilder decoratorBuilder = (DecoratingServiceBindingBuilder)sb.routeDecorator().pathPrefix(path);
            for (Route loginRoute : AuthProvider.LOGIN_API_ROUTES) {
                decoratorBuilder.exclude(loginRoute);
            }
            for (Route logoutRoute : AuthProvider.LOGOUT_API_ROUTES) {
                decoratorBuilder.exclude(logoutRoute);
            }
            decoratorBuilder.build(decorator);
        }
        assert (this.statusManager != null);
        ContextPathServicesBuilder apiV1ServiceBuilder = sb.contextPath(new String[]{"/api/v1/"});
        ((ContextPathServicesBuilder)((ContextPathServicesBuilder)((ContextPathServicesBuilder)apiV1ServiceBuilder.annotatedService((Object)new AdministrativeService(executor, this.statusManager))).annotatedService((Object)new ProjectServiceV1(projectApiManager, executor))).annotatedService((Object)new RepositoryServiceV1(executor, mds))).annotatedService((Object)new CredentialServiceV1(projectApiManager, executor));
        if (GIT_MIRROR_ENABLED) {
            this.mirrorRunner = new MirrorRunner(projectApiManager, executor, this.cfg, meterRegistry);
            apiV1ServiceBuilder.annotatedService((Object)new MirroringServiceV1(projectApiManager, executor, this.mirrorRunner));
        }
        ((ContextPathAnnotatedServiceConfigSetters)apiV1ServiceBuilder.annotatedService().defaultServiceNaming(new ServiceNaming(){
            private final String serviceName = ContentServiceV1.class.getName();
            private final String watchServiceName = this.serviceName.replace("ContentServiceV1", "WatchContentServiceV1");

            public String serviceName(ServiceRequestContext ctx) {
                if (ctx.request().headers().contains((CharSequence)HttpHeaderNames.IF_NONE_MATCH)) {
                    return this.watchServiceName;
                }
                return this.serviceName;
            }
        })).build((Object)new ContentServiceV1(executor, watchService, meterRegistry));
        if (authProvider != null) {
            sb.service("/security_enabled", (HttpService)new AbstractHttpService(){

                protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) {
                    return HttpResponse.of((HttpStatus)HttpStatus.OK);
                }
            });
            AuthConfig authCfg = this.cfg.authConfig();
            assert (authCfg != null) : "authCfg";
            ((ContextPathServicesBuilder)apiV1ServiceBuilder.annotatedService((Object)new MetadataApiService(executor, mds, authCfg.loginNameNormalizer()))).annotatedService((Object)new TokenService(executor, mds));
            Optional.ofNullable(authProvider.loginApiService()).ifPresent(login -> AuthProvider.LOGIN_API_ROUTES.forEach(mapping -> sb.service(mapping, login)));
            HttpService logout = Optional.ofNullable(authProvider.logoutApiService()).orElseGet(() -> new DefaultLogoutService(executor));
            for (Route route : AuthProvider.LOGOUT_API_ROUTES) {
                sb.service(route, (HttpService)decorator.apply((HttpService)logout));
            }
            authProvider.moreServices().forEach(x$0 -> sb.service(x$0, new Function[0]));
        }
        ((AnnotatedServiceBindingBuilder)((AnnotatedServiceBindingBuilder)sb.annotatedService().decorator(decorator)).decorator(DecodingService.newDecorator())).build((Object)new GitHttpService(projectApiManager));
        if (this.cfg.isWebAppEnabled()) {
            ((ContextPathServicesBuilder)sb.contextPath(new String[]{"/api/v0/"}).annotatedService((Object)new UserService(executor))).annotatedService((Object)new RepositoryService(projectApiManager, executor));
            if (authProvider != null) {
                sb.service("/link/auth/login", authProvider.webLoginService());
                sb.service("/link/auth/logout", authProvider.webLogoutService());
            }
            sb.serviceUnder("/app", HttpFile.of((ClassLoader)CentralDogma.class.getClassLoader(), (String)"com/linecorp/centraldogma/webapp/index.html").asService());
            ((ServiceBindingBuilder)((ServiceBindingBuilder)((ServiceBindingBuilder)sb.route().pathPrefix("/")).exclude("prefix:/app")).exclude("prefix:/api")).build((HttpService)FileService.builder((ClassLoader)CentralDogma.class.getClassLoader(), (String)"com/linecorp/centraldogma/webapp").cacheControl((CacheControl)ServerCacheControl.REVALIDATED).autoDecompress(true).serveCompressedFiles(true).fallbackFileExtensions(new String[]{"html"}).build());
        }
        sb.errorHandler((ServerErrorHandler)new HttpApiExceptionHandler());
    }

    private static void configCors(ServerBuilder sb, @Nullable CorsConfig corsConfig) {
        if (corsConfig == null) {
            return;
        }
        sb.decorator(CorsService.builder(corsConfig.allowedOrigins()).allowRequestMethods((Iterable)HttpMethod.knownMethods()).allowAllRequestHeaders(true).allowCredentials().maxAge((long)corsConfig.maxAgeSeconds()).newDecorator());
    }

    private static void configManagement(ServerBuilder sb, @Nullable ManagementConfig managementConfig) {
        if (managementConfig == null) {
            return;
        }
        int port = managementConfig.port();
        if (port == 0) {
            logger.info("'management.port' is 0, using the same ports as 'ports'.");
            ((ServiceBindingBuilder)((ServiceBindingBuilder)sb.route().pathPrefix(managementConfig.path())).defaultServiceName("management")).build((HttpService)ManagementService.of());
        } else {
            SessionProtocol managementProtocol = managementConfig.protocol();
            String address = managementConfig.address();
            if (address == null) {
                sb.port(new ServerPort(port, new SessionProtocol[]{managementProtocol}));
            } else {
                sb.port(new ServerPort(new InetSocketAddress(address, port), new SessionProtocol[]{managementProtocol}));
            }
            ((VirtualHostServiceBindingBuilder)((VirtualHostServiceBindingBuilder)sb.virtualHost(port).route().pathPrefix(managementConfig.path())).defaultServiceName("management")).build((HttpService)ManagementService.of());
        }
    }

    private static Function<? super HttpService, EncodingService> contentEncodingDecorator() {
        return delegate -> EncodingService.builder().encodableContentTypes(contentType -> {
            if ("application".equals(contentType.type())) {
                String subtype;
                switch (subtype = contentType.subtype()) {
                    case "json": 
                    case "xml": 
                    case "x-thrift": 
                    case "x-git-upload-pack-advertisement": 
                    case "x-git-upload-pack-result": {
                        return true;
                    }
                }
                return subtype.endsWith("+json") || subtype.endsWith("+xml") || subtype.startsWith("vnd.apache.thrift.");
            }
            return false;
        }).build(delegate);
    }

    private void configureMetrics(ServerBuilder sb, MeterRegistry registry) {
        sb.meterRegistry(registry);
        if (registry instanceof PrometheusMeterRegistry) {
            PrometheusMeterRegistry prometheusMeterRegistry = (PrometheusMeterRegistry)registry;
            sb.service("/monitor/metrics", (HttpService)PrometheusExpositionService.of((PrometheusRegistry)prometheusMeterRegistry.getPrometheusRegistry()));
        } else if (registry instanceof CompositeMeterRegistry) {
            PrometheusMeterRegistry prometheusMeterRegistry = PrometheusMeterRegistries.newRegistry();
            ((CompositeMeterRegistry)registry).add((MeterRegistry)prometheusMeterRegistry);
            sb.service("/monitor/metrics", (HttpService)PrometheusExpositionService.of((PrometheusRegistry)prometheusMeterRegistry.getPrometheusRegistry()));
            this.meterRegistryToBeClosed = prometheusMeterRegistry;
        } else {
            logger.info("Not exposing a prometheus endpoint for the type: {}", registry.getClass());
        }
        sb.decorator(MetricCollectingService.newDecorator((MeterIdPrefixFunction)MeterIdPrefixFunction.ofDefault((String)"api")));
        new FileDescriptorMetrics().bindTo(registry);
        new ProcessorMetrics().bindTo(registry);
        new ClassLoaderMetrics().bindTo(registry);
        new UptimeMetrics().bindTo(registry);
        new DiskSpaceMetrics(this.cfg.dataDir()).bindTo(registry);
        new JvmGcMetrics().bindTo(registry);
        new JvmMemoryMetrics().bindTo(registry);
        new JvmThreadMetrics().bindTo(registry);
        ExecutorServiceMetrics.monitor((MeterRegistry)registry, (ExecutorService)ForkJoinPool.commonPool(), (String)"commonPool", (Tag[])new Tag[0]);
    }

    private void doStop() {
        if (this.server == null) {
            return;
        }
        Server server = this.server;
        CommandExecutor executor = this.executor;
        ProjectManager pm = this.pm;
        ExecutorService repositoryWorker = this.repositoryWorker;
        ScheduledExecutorService purgeWorker = this.purgeWorker;
        SessionManager sessionManager = this.sessionManager;
        MirrorRunner mirrorRunner = this.mirrorRunner;
        this.server = null;
        this.executor = null;
        this.pm = null;
        this.repositoryWorker = null;
        this.sessionManager = null;
        this.mirrorRunner = null;
        if (this.meterRegistryToBeClosed != null) {
            assert (this.meterRegistry instanceof CompositeMeterRegistry);
            ((CompositeMeterRegistry)this.meterRegistry).remove(this.meterRegistryToBeClosed);
            this.meterRegistryToBeClosed.close();
            this.meterRegistryToBeClosed = null;
        }
        logger.info("Stopping the Central Dogma ..");
        if (!CentralDogma.doStop(server, executor, pm, repositoryWorker, purgeWorker, sessionManager, mirrorRunner)) {
            logger.warn("Stopped the Central Dogma with failure.");
        } else {
            logger.info("Stopped the Central Dogma successfully.");
        }
        this.projectInitializer = null;
    }

    private static boolean doStop(@Nullable Server server, @Nullable CommandExecutor executor, @Nullable ProjectManager pm, @Nullable ExecutorService repositoryWorker, @Nullable ExecutorService purgeWorker, @Nullable SessionManager sessionManager, @Nullable MirrorRunner mirrorRunner) {
        boolean success = true;
        try {
            if (sessionManager != null) {
                logger.info("Stopping the session manager ..");
                sessionManager.close();
                logger.info("Stopped the session manager.");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the session manager:", t);
        }
        try {
            if (pm != null) {
                logger.info("Stopping the project manager ..");
                pm.close(ShuttingDownException::new);
                logger.info("Stopped the project manager.");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the project manager:", t);
        }
        try {
            if (executor != null) {
                logger.info("Stopping the command executor ..");
                executor.stop();
                logger.info("Stopped the command executor.");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the command executor:", t);
        }
        BiFunction<ExecutorService, String, Boolean> stopWorker = (worker, name) -> {
            try {
                if (worker != null && !worker.isTerminated()) {
                    logger.info("Stopping the {} worker ..", name);
                    boolean interruptLater = false;
                    while (!worker.isTerminated()) {
                        worker.shutdownNow();
                        try {
                            worker.awaitTermination(1L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            interruptLater = true;
                        }
                    }
                    logger.info("Stopped the {} worker.", name);
                    if (interruptLater) {
                        Thread.currentThread().interrupt();
                    }
                }
                return true;
            }
            catch (Throwable t) {
                logger.warn("Failed to stop the " + name + " worker:", t);
                return false;
            }
        };
        if (!stopWorker.apply(repositoryWorker, "repository").booleanValue()) {
            success = false;
        }
        if (!stopWorker.apply(purgeWorker, "purge").booleanValue()) {
            success = false;
        }
        try {
            if (mirrorRunner != null) {
                logger.info("Stopping the mirror runner..");
                mirrorRunner.close();
                logger.info("Stopped the mirror runner.");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the mirror runner:", t);
        }
        try {
            if (server != null) {
                logger.info("Stopping the RPC server ..");
                server.stop().join();
                logger.info("Stopped the RPC server.");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the RPC server:", t);
        }
        return success;
    }

    static {
        Jackson.registerModules((Module[])new Module[]{new SimpleModule().addSerializer(CacheStats.class, (JsonSerializer)new CacheStatsSerializer())});
        boolean gitMirrorEnabled = false;
        for (MirrorProvider mirrorProvider : MirrorConfig.MIRROR_PROVIDERS) {
            if (!"com.linecorp.centraldogma.server.internal.mirror.GitMirrorProvider".equals(mirrorProvider.getClass().getName())) continue;
            gitMirrorEnabled = true;
            break;
        }
        logger.info("Git mirroring: {}", (Object)(gitMirrorEnabled ? "enabled" : "disabled ('centraldogma-server-mirror-git' module is not available)"));
        GIT_MIRROR_ENABLED = gitMirrorEnabled;
    }

    private final class CentralDogmaStartStop
    extends StartStopSupport<Void, Void, Void, Void> {
        @Nullable
        private final PluginGroup pluginsForAllReplicas;

        CentralDogmaStartStop(PluginGroup pluginsForAllReplicas) {
            super((Executor)GlobalEventExecutor.INSTANCE);
            this.pluginsForAllReplicas = pluginsForAllReplicas;
        }

        protected CompletionStage<Void> doStart(@Nullable Void unused) throws Exception {
            return this.execute("startup", () -> {
                try {
                    CentralDogma.this.doStart();
                    if (this.pluginsForAllReplicas != null) {
                        ProjectManager pm = CentralDogma.this.pm;
                        CommandExecutor executor = CentralDogma.this.executor;
                        MeterRegistry meterRegistry = CentralDogma.this.meterRegistry;
                        if (pm != null && executor != null && meterRegistry != null) {
                            this.pluginsForAllReplicas.start(CentralDogma.this.cfg, pm, executor, meterRegistry, CentralDogma.this.purgeWorker, CentralDogma.this.projectInitializer).join();
                        }
                    }
                }
                catch (Exception e) {
                    Exceptions.throwUnsafely((Throwable)e);
                }
            });
        }

        protected CompletionStage<Void> doStop(@Nullable Void unused) throws Exception {
            return this.execute("shutdown", () -> {
                if (this.pluginsForAllReplicas != null) {
                    ProjectManager pm = CentralDogma.this.pm;
                    CommandExecutor executor = CentralDogma.this.executor;
                    MeterRegistry meterRegistry = CentralDogma.this.meterRegistry;
                    if (pm != null && executor != null && meterRegistry != null) {
                        this.pluginsForAllReplicas.stop(CentralDogma.this.cfg, pm, executor, meterRegistry, CentralDogma.this.purgeWorker, CentralDogma.this.projectInitializer).join();
                    }
                }
                CentralDogma.this.doStop();
            });
        }

        private CompletionStage<Void> execute(String mode, Runnable task) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            Thread thread = new Thread(() -> {
                try {
                    task.run();
                    future.complete(null);
                }
                catch (Throwable cause) {
                    future.completeExceptionally(cause);
                }
            }, "dogma-" + mode + "-0x" + Long.toHexString((long)CentralDogma.this.hashCode() & 0xFFFFFFFFL));
            thread.start();
            return future;
        }
    }
}

