/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.repository;

import com.linecorp.centraldogma.internal.Util;
import java.util.Map;
import javax.annotation.Nullable;

public class FindOption<T> {
    public static final FindOption<Boolean> FETCH_CONTENT = new FindOption<Boolean>("FETCH_CONTENT", true);
    public static final FindOption<Integer> MAX_ENTRIES = new FindOption<Integer>("MAX_ENTRIES", Integer.valueOf(Integer.MAX_VALUE)){

        @Override
        boolean isValid(Integer value) {
            return value > 0;
        }
    };
    private final String name;
    private final T defaultValue;
    private final String fullName;

    FindOption(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.fullName = Util.simpleTypeName(FindOption.class) + '.' + name;
    }

    public String name() {
        return this.name;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    boolean isValid(T value) {
        return true;
    }

    public T get(@Nullable Map<FindOption<?>, ?> options) {
        if (options == null) {
            return this.defaultValue();
        }
        Object value = options.get(this);
        if (value == null) {
            return this.defaultValue();
        }
        return (T)value;
    }

    public String toString() {
        return this.name();
    }
}

