/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User
implements Identifiable,
Serializable {
    private static final long serialVersionUID = -5429782019985526549L;
    private static final String LEVEL_ANONYMOUS_STR = "LEVEL_ANONYMOUS";
    private static final String LEVEL_USER_STR = "LEVEL_USER";
    private static final String LEVEL_ADMIN_STR = "LEVEL_ADMIN";
    public static final List<String> LEVEL_ANONYMOUS = ImmutableList.of((Object)"LEVEL_ANONYMOUS");
    public static final List<String> LEVEL_USER = ImmutableList.of((Object)"LEVEL_USER");
    public static final List<String> LEVEL_ADMIN = ImmutableList.of((Object)"LEVEL_ADMIN", (Object)"LEVEL_USER");
    public static final User ANONYMOUS = new User("anonymous@localhost.localdomain", LEVEL_ANONYMOUS);
    public static final User DEFAULT = new User("user@localhost.localdomain", LEVEL_USER);
    public static final User ADMIN = new User("admin@localhost.localdomain", LEVEL_ADMIN);
    private final String login;
    private final String name;
    private final String email;
    private final List<String> roles;
    private final boolean isAdmin;
    private final boolean isAnonymous;

    @JsonCreator
    public User(@JsonProperty(value="login") String login, @JsonProperty(value="name") String name, @JsonProperty(value="email") String email, @JsonProperty(value="roles") List<String> roles) {
        this.login = Objects.requireNonNull(login, "login");
        this.name = Objects.requireNonNull(name, "name");
        this.email = Objects.requireNonNull(email, "email");
        this.roles = ImmutableList.copyOf((Collection)Objects.requireNonNull(roles, "roles"));
        this.isAdmin = roles.stream().anyMatch(LEVEL_ADMIN_STR::equals);
        this.isAnonymous = roles.stream().anyMatch(LEVEL_ANONYMOUS_STR::equals);
    }

    public User(String login) {
        this(login, LEVEL_USER);
    }

    public User(String login, List<String> roles) {
        if (Strings.isNullOrEmpty((String)login)) {
            throw new IllegalArgumentException("login");
        }
        Objects.requireNonNull(roles, "roles");
        this.login = login;
        this.email = Util.toEmailAddress((String)login, (String)"login");
        this.name = Util.emailToUsername((String)this.email, (String)"login");
        this.roles = ImmutableList.copyOf(roles);
        this.isAdmin = roles.stream().anyMatch(LEVEL_ADMIN_STR::equals);
        this.isAnonymous = roles.stream().anyMatch(LEVEL_ANONYMOUS_STR::equals);
    }

    @JsonProperty
    public String login() {
        return this.login;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public String email() {
        return this.email;
    }

    @JsonProperty
    public List<String> roles() {
        return this.roles;
    }

    @Override
    public String id() {
        return this.email();
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.login.equals(user.login);
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("login", (Object)this.login()).add("name", (Object)this.name()).add("email", (Object)this.email()).add("roles", this.roles()).add("isAdmin", this.isAdmin()).toString();
    }
}

