/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.CronType;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.definition.CronDefinitionBuilder;
import com.linecorp.centraldogma.internal.shaded.cronutils.parser.CronParser;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorContext;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.mirror.MirrorProvider;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class MirrorConfig {
    private static final Logger logger = LoggerFactory.getLogger(MirrorConfig.class);
    public static final String DEFAULT_SCHEDULE = "0 * * * * ?";
    public static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    public static final List<MirrorProvider> MIRROR_PROVIDERS = ImmutableList.copyOf(ServiceLoader.load(MirrorProvider.class));
    private final String id;
    private final boolean enabled;
    private final MirrorDirection direction;
    @Nullable
    private final String localRepo;
    private final String localPath;
    private final URI remoteUri;
    @Nullable
    private final String gitignore;
    @Nullable
    private final String credentialId;
    private final Cron schedule;

    /*
     * Unable to fully structure code
     */
    @JsonCreator
    public MirrorConfig(@JsonProperty(value="id") String id, @JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="schedule") @Nullable String schedule, @JsonProperty(value="direction", required=true) MirrorDirection direction, @JsonProperty(value="localRepo", required=true) String localRepo, @JsonProperty(value="localPath") @Nullable String localPath, @JsonProperty(value="remoteUri", required=true) URI remoteUri, @JsonProperty(value="gitignore") @Nullable Object gitignore, @JsonProperty(value="credentialId") @Nullable String credentialId) {
        super();
        this.id = Objects.requireNonNull(id, "id");
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)true);
        this.schedule = MirrorConfig.CRON_PARSER.parse((String)MoreObjects.firstNonNull((Object)schedule, (Object)"0 * * * * ?"));
        this.direction = Objects.requireNonNull(direction, "direction");
        this.localRepo = Objects.requireNonNull(localRepo, "localRepo");
        this.localPath = (String)MoreObjects.firstNonNull((Object)localPath, (Object)"/");
        this.remoteUri = Objects.requireNonNull(remoteUri, "remoteUri");
        if (gitignore == null) ** GOTO lbl21
        if (!(gitignore instanceof Iterable)) ** GOTO lbl-1000
        if (Streams.stream((Iterable)((Iterable)gitignore)).allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(String.class))) {
            this.gitignore = String.join((CharSequence)"\n", (Iterable)gitignore);
        } else if (gitignore instanceof String) {
            this.gitignore = (String)gitignore;
        } else {
            throw new IllegalArgumentException("gitignore: " + gitignore + " (expected: either a string or an array of strings)");
lbl21:
            // 1 sources

            this.gitignore = null;
        }
        this.credentialId = Strings.emptyToNull((String)credentialId);
    }

    @Nullable
    Mirror toMirror(Project parent, Iterable<MirrorCredential> credentials) {
        if (this.localRepo == null || !parent.repos().exists(this.localRepo)) {
            return null;
        }
        MirrorContext mirrorContext = new MirrorContext(this.id, this.enabled, this.schedule, this.direction, MirrorConfig.findCredential(credentials, this.remoteUri, this.credentialId), (Repository)parent.repos().get(this.localRepo), this.localPath, this.remoteUri, this.gitignore);
        for (MirrorProvider mirrorProvider : MIRROR_PROVIDERS) {
            Mirror mirror = mirrorProvider.newMirror(mirrorContext);
            if (mirror == null) continue;
            return mirror;
        }
        throw new IllegalArgumentException("could not find a mirror provider for " + mirrorContext);
    }

    public static MirrorCredential findCredential(Iterable<MirrorCredential> credentials, URI remoteUri, @Nullable String credentialId) {
        if (credentialId != null) {
            for (MirrorCredential c : credentials) {
                String id = c.id();
                if (!credentialId.equals(id)) continue;
                return c;
            }
        } else {
            for (MirrorCredential c : credentials) {
                if (!c.matches(remoteUri)) continue;
                return c;
            }
        }
        return MirrorCredential.FALLBACK;
    }

    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @JsonProperty(value="direction")
    public MirrorDirection direction() {
        return this.direction;
    }

    @Nullable
    @JsonProperty(value="localRepo")
    public String localRepo() {
        return this.localRepo;
    }

    @JsonProperty(value="localPath")
    public String localPath() {
        return this.localPath;
    }

    @JsonProperty(value="remoteUri")
    public String remoteUri() {
        return this.remoteUri.toString();
    }

    @JsonProperty(value="gitignore")
    @Nullable
    public String gitignore() {
        return this.gitignore;
    }

    @Nullable
    @JsonProperty(value="credentialId")
    public String credentialId() {
        return this.credentialId;
    }

    @JsonProperty(value="schedule")
    public String schedule() {
        return this.schedule.asString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("enabled", this.enabled).add("direction", (Object)this.direction).add("localRepo", (Object)this.localRepo).add("localPath", (Object)this.localPath).add("remoteUri", (Object)this.remoteUri).add("gitignore", (Object)this.gitignore).add("credentialId", (Object)this.credentialId).add("schedule", (Object)this.schedule).toString();
    }

    static {
        logger.debug("Available {}s: {}", (Object)MirrorProvider.class.getSimpleName(), MIRROR_PROVIDERS);
    }
}

