/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class ProjectApiManager {
    private final ProjectManager projectManager;
    private final CommandExecutor commandExecutor;
    private final MetadataService metadataService;

    public ProjectApiManager(ProjectManager projectManager, CommandExecutor commandExecutor, MetadataService metadataService) {
        this.projectManager = projectManager;
        this.commandExecutor = commandExecutor;
        this.metadataService = metadataService;
    }

    public Map<String, Project> listProjects() {
        Map<String, Project> projects = this.projectManager.list();
        if (ProjectApiManager.isAdmin()) {
            return projects;
        }
        return ProjectApiManager.listProjectsWithoutInternal(projects);
    }

    private static boolean isAdmin() {
        User currentUserOrNull = AuthUtil.currentUserOrNull();
        if (currentUserOrNull == null) {
            return false;
        }
        return currentUserOrNull.isAdmin();
    }

    public static Map<String, Project> listProjectsWithoutInternal(Map<String, Project> projects) {
        LinkedHashMap<String, Project> result = new LinkedHashMap<String, Project>(projects.size() - 1);
        for (Map.Entry<String, Project> entry : projects.entrySet()) {
            if (ProjectApiManager.isInternalProject(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Instant> listRemovedProjects() {
        return this.projectManager.listRemoved();
    }

    public CompletableFuture<Void> createProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "create");
        return this.commandExecutor.execute(Command.createProject(author, projectName));
    }

    private static void checkInternalProject(String projectName, String operation) {
        if (ProjectApiManager.isInternalProject(projectName)) {
            throw new IllegalArgumentException("Cannot " + operation + ' ' + projectName);
        }
    }

    public CompletableFuture<ProjectMetadata> getProjectMetadata(String projectName) {
        return this.metadataService.getProject(projectName);
    }

    public CompletableFuture<Void> removeProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "remove");
        return this.metadataService.removeProject(author, projectName).thenCompose(unused -> this.commandExecutor.execute(Command.removeProject(author, projectName)));
    }

    public CompletableFuture<Void> purgeProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "purge");
        return this.commandExecutor.execute(Command.purgeProject(author, projectName));
    }

    public CompletableFuture<Revision> unremoveProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "unremove");
        return this.commandExecutor.execute(Command.unremoveProject(author, projectName)).thenCompose(unused -> this.metadataService.restoreProject(author, projectName));
    }

    public Project getProject(String projectName) {
        if (ProjectApiManager.isInternalProject(projectName) && !ProjectApiManager.isAdmin()) {
            throw new IllegalArgumentException("Cannot access " + projectName);
        }
        return (Project)this.projectManager.get(projectName);
    }

    private static boolean isInternalProject(String projectName) {
        return projectName.startsWith("@") || "dogma".equals(projectName);
    }

    public boolean exists(String projectName) {
        if (ProjectApiManager.isInternalProject(projectName) && !ProjectApiManager.isAdmin()) {
            throw new IllegalArgumentException("Cannot access " + projectName);
        }
        return this.projectManager.exists(projectName);
    }
}

