/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.FutureCallback;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.Futures;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListenableFuture;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListenableScheduledFuture;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListeningExecutorService;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListeningScheduledExecutorService;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.MoreExecutors;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.MirroringService;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.mirror.MirroringMigrationService;
import com.linecorp.centraldogma.server.internal.mirror.MirroringTask;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMirroringService
implements MirroringService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMirroringService.class);
    private static final Duration TICK = Duration.ofSeconds(1L);
    private final File workDir;
    private final ProjectManager projectManager;
    private final int numThreads;
    private final int maxNumFilesPerMirror;
    private final long maxNumBytesPerMirror;
    private volatile CommandExecutor commandExecutor;
    private volatile ListeningScheduledExecutorService scheduler;
    private volatile ListeningExecutorService worker;
    private ZonedDateTime lastExecutionTime;
    private final MeterRegistry meterRegistry;

    DefaultMirroringService(File workDir, ProjectManager projectManager, MeterRegistry meterRegistry, int numThreads, int maxNumFilesPerMirror, long maxNumBytesPerMirror) {
        this.workDir = Objects.requireNonNull(workDir, "workDir");
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (String)"numThreads: %s (expected: > 0)", (int)numThreads);
        Preconditions.checkArgument((maxNumFilesPerMirror > 0 ? 1 : 0) != 0, (String)"maxNumFilesPerMirror: %s (expected: > 0)", (int)maxNumFilesPerMirror);
        Preconditions.checkArgument((maxNumBytesPerMirror > 0L ? 1 : 0) != 0, (String)"maxNumBytesPerMirror: %s (expected: > 0)", (long)maxNumBytesPerMirror);
        this.numThreads = numThreads;
        this.maxNumFilesPerMirror = maxNumFilesPerMirror;
        this.maxNumBytesPerMirror = maxNumBytesPerMirror;
    }

    public boolean isStarted() {
        return this.scheduler != null;
    }

    public synchronized void start(CommandExecutor commandExecutor) {
        if (this.isStarted()) {
            return;
        }
        this.commandExecutor = Objects.requireNonNull(commandExecutor, "commandExecutor");
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("mirroring-scheduler", true));
        executorService = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ScheduledExecutorService)executorService, (String)"mirroringScheduler", (Tag[])new Tag[0]);
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)executorService);
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        this.worker = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(0, this.numThreads, 90L, TimeUnit.SECONDS, workQueue, (ThreadFactory)new DefaultThreadFactory("mirroring-worker", true), (rejectedTask, executor) -> {
            try {
                workQueue.put(rejectedTask);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }));
        try {
            new MirroringMigrationService(this.projectManager, commandExecutor).migrate();
        }
        catch (Throwable e) {
            logger.error("Git mirroring stopped due to an unexpected exception while migrating mirrors.json:", e);
            return;
        }
        ListenableScheduledFuture future = this.scheduler.scheduleWithFixedDelay(this::schedulePendingMirrors, TICK.getSeconds(), TICK.getSeconds(), TimeUnit.SECONDS);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object result) {
            }

            public void onFailure(Throwable cause) {
                logger.error("Git mirroring scheduler stopped due to an unexpected exception:", cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        ListeningScheduledExecutorService scheduler = this.scheduler;
        ListeningExecutorService worker = this.worker;
        try {
            boolean interrupted;
            boolean bl = interrupted = DefaultMirroringService.terminate((ExecutorService)scheduler) || DefaultMirroringService.terminate((ExecutorService)worker);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.scheduler = null;
            this.worker = null;
        }
    }

    private static boolean terminate(ExecutorService executor) {
        if (executor == null) {
            return false;
        }
        boolean interrupted = false;
        while (true) {
            executor.shutdownNow();
            try {
                if (!executor.awaitTermination(1L, TimeUnit.MINUTES)) continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        return interrupted;
    }

    private void schedulePendingMirrors() {
        ZonedDateTime now = ZonedDateTime.now();
        if (this.lastExecutionTime == null) {
            this.lastExecutionTime = now.minus(TICK);
        }
        ZonedDateTime currentLastExecutionTime = this.lastExecutionTime;
        this.lastExecutionTime = now;
        this.projectManager.list().values().forEach(project -> {
            List<Mirror> mirrors;
            try {
                mirrors = project.metaRepo().mirrors().get(5L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.warn("Failed to load the mirror list within 5 seconds. project: {}", (Object)project.name(), (Object)e);
                return;
            }
            catch (Exception e) {
                logger.warn("Failed to load the mirror list from: {}", (Object)project.name(), (Object)e);
                return;
            }
            mirrors.forEach(m -> {
                try {
                    if (m.nextExecutionTime(currentLastExecutionTime).compareTo(now) < 0) {
                        this.run((Project)project, (Mirror)m);
                    }
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception while mirroring: {}", m, (Object)e);
                }
            });
        });
    }

    @Override
    public CompletableFuture<Void> mirror() {
        if (this.commandExecutor == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> this.projectManager.list().values().forEach(p -> {
            try {
                p.metaRepo().mirrors().get(5L, TimeUnit.SECONDS).forEach(m -> this.run((Mirror)m, p.name(), false));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Failed to load mirror list with in 5 seconds. project: " + p.name(), e);
            }
        }), (Executor)this.worker);
    }

    private void run(Project project, final Mirror m) {
        ListenableFuture future = this.worker.submit(() -> this.run(m, project.name(), true));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object result) {
            }

            public void onFailure(Throwable cause) {
                logger.warn("Unexpected Git mirroring failure: {}", (Object)m, (Object)cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void run(Mirror m, String projectName, boolean logOnFailure) {
        logger.info("Mirroring: {}", (Object)m);
        try {
            new MirroringTask(m, projectName, this.meterRegistry).run(this.workDir, this.commandExecutor, this.maxNumFilesPerMirror, this.maxNumBytesPerMirror);
        }
        catch (Exception e) {
            if (logOnFailure) {
                logger.warn("Unexpected exception while mirroring: {}", (Object)m, (Object)e);
            }
            if (e instanceof MirrorException) {
                throw (MirrorException)e;
            }
            throw new MirrorException(e);
        }
    }
}

