/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ProducesJson
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class CredentialServiceV1
extends AbstractService {
    private final ProjectApiManager projectApiManager;

    public CredentialServiceV1(ProjectApiManager projectApiManager, CommandExecutor executor) {
        super(executor);
        this.projectApiManager = projectApiManager;
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/credentials")
    public CompletableFuture<List<MirrorCredential>> listCredentials(@Param String projectName) {
        return this.metaRepo(projectName).credentials();
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/credentials/{id}")
    public CompletableFuture<MirrorCredential> getCredentialById(@Param String projectName, @Param String id) {
        return this.metaRepo(projectName).credential(id);
    }

    @RequiresWritePermission(repository="meta")
    @Post(value="/projects/{projectName}/credentials")
    @ConsumesJson
    @StatusCode(value=201)
    public CompletableFuture<PushResultDto> createCredential(@Param String projectName, MirrorCredential credential, Author author) {
        return this.createOrUpdate(projectName, credential, author, false);
    }

    @RequiresWritePermission(repository="meta")
    @Put(value="/projects/{projectName}/credentials")
    @ConsumesJson
    public CompletableFuture<PushResultDto> updateCredential(@Param String projectName, MirrorCredential credential, Author author) {
        return this.createOrUpdate(projectName, credential, author, true);
    }

    private CompletableFuture<PushResultDto> createOrUpdate(String projectName, MirrorCredential credential, Author author, boolean update) {
        return this.metaRepo(projectName).createPushCommand(credential, author, update).thenCompose(command -> this.executor().execute(command).thenApply(result -> new PushResultDto(result.revision(), command.timestamp())));
    }

    private MetaRepository metaRepo(String projectName) {
        return this.projectApiManager.getProject(projectName).metaRepo();
    }
}

