/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeType;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.InvalidPushException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.api.v1.ChangeDto;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.api.v1.EntryDto;
import com.linecorp.centraldogma.internal.api.v1.MergedEntryDto;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.api.v1.WatchResultDto;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.base.Throwables;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.RepositoryServiceV1;
import com.linecorp.centraldogma.server.internal.api.WatchService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.internal.api.converter.ChangesRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.CommitMessageRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.MergeQueryRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.QueryRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.WatchRequestConverter;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

@ProducesJson
@RequiresReadPermission
@RequestConverter(value=CommitMessageRequestConverter.class)
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class ContentServiceV1
extends AbstractService {
    private static final String MIRROR_LOCAL_REPO = "localRepo";
    private final WatchService watchService;
    private final MeterRegistry meterRegistry;

    public ContentServiceV1(CommandExecutor executor, WatchService watchService, MeterRegistry meterRegistry) {
        super(executor);
        this.watchService = Objects.requireNonNull(watchService, "watchService");
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/list(?<path>(|/.*))$")
    public CompletableFuture<List<EntryDto<?>>> listFiles(ServiceRequestContext ctx, @Param String path, @Param @Default(value="-1") String revision, Repository repository) {
        String normalizedPath = ContentServiceV1.normalizePath(path);
        Revision normalizedRev = repository.normalizeNow(new Revision(revision));
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, normalizedRev);
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, normalizedRev, false, future);
        return future;
    }

    private static void listFiles(Repository repository, String pathPattern, Revision normalizedRev, boolean withContent, CompletableFuture<List<EntryDto<?>>> result) {
        Map<FindOption<?>, ?> options = withContent ? FindOptions.FIND_ALL_WITH_CONTENT : FindOptions.FIND_ALL_WITHOUT_CONTENT;
        repository.find(normalizedRev, pathPattern, options).handle((entries, thrown) -> {
            if (thrown != null) {
                result.completeExceptionally((Throwable)thrown);
                return null;
            }
            if (Util.isValidFilePath((String)pathPattern) && entries.size() == 1 && ((Entry)entries.values().iterator().next()).type() == EntryType.DIRECTORY) {
                ContentServiceV1.listFiles(repository, pathPattern + "/*", normalizedRev, withContent, result);
            } else {
                result.complete((List)entries.values().stream().map(entry -> DtoConverter.convert(repository, normalizedRev, entry, withContent)).collect(ImmutableList.toImmutableList()));
            }
            return null;
        });
    }

    private static String normalizePath(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return "/*";
        }
        if (Util.isValidFilePath((String)path)) {
            return path;
        }
        if (Util.isValidDirPath((String)path)) {
            if (path.endsWith("/")) {
                return path + '*';
            }
            return path + "/*";
        }
        return path;
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/contents")
    @RequiresWritePermission
    public CompletableFuture<PushResultDto> push(ServiceRequestContext ctx, @Param @Default(value="-1") String revision, Repository repository, Author author, CommitMessageDto commitMessage, @RequestConverter(value=ChangesRequestConverter.class) Iterable<Change<?>> changes) {
        User user = AuthUtil.currentUser(ctx);
        ContentServiceV1.checkPush(repository.name(), changes, user.isAdmin());
        this.meterRegistry.counter("commits.push", new String[]{"project", repository.parent().name(), "repository", repository.name()}).increment();
        long commitTimeMillis = System.currentTimeMillis();
        return this.push(commitTimeMillis, author, repository, new Revision(revision), commitMessage, changes).toCompletableFuture().thenApply(rrev -> DtoConverter.convert(rrev, commitTimeMillis));
    }

    private CompletableFuture<Revision> push(long commitTimeMills, Author author, Repository repository, Revision revision, CommitMessageDto commitMessage, Iterable<Change<?>> changes) {
        String summary = commitMessage.summary();
        String detail = commitMessage.detail();
        Markup markup = commitMessage.markup();
        return this.execute(Command.push((Long)commitTimeMills, author, repository.parent().name(), repository.name(), revision, summary, detail, markup, changes)).thenApply(CommitResult::revision);
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/preview")
    public CompletableFuture<Iterable<ChangeDto<?>>> preview(ServiceRequestContext ctx, @Param @Default(value="-1") String revision, Repository repository, @RequestConverter(value=ChangesRequestConverter.class) Iterable<Change<?>> changes) {
        Revision baseRevision = new Revision(revision);
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, baseRevision);
        CompletableFuture<Map<String, Change<?>>> changesFuture = repository.previewDiff(baseRevision, changes);
        return changesFuture.thenApply(previewDiffs -> (Iterable)previewDiffs.values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/contents(?<path>(|/.*))$")
    public CompletableFuture<?> getFiles(ServiceRequestContext ctx, @Param String path, @Param @Default(value="-1") String revision, Repository repository, @RequestConverter(value=WatchRequestConverter.class) @Nullable WatchRequestConverter.WatchRequest watchRequest, @RequestConverter(value=QueryRequestConverter.class) @Nullable Query<?> query) {
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, new Revision(revision));
        String normalizedPath = ContentServiceV1.normalizePath(path);
        if (watchRequest != null) {
            Revision lastKnownRevision = watchRequest.lastKnownRevision();
            long timeOutMillis = watchRequest.timeoutMillis();
            boolean errorOnEntryNotFound = watchRequest.notifyEntryNotFound();
            if (query != null) {
                return this.watchFile(ctx, repository, lastKnownRevision, query, timeOutMillis, errorOnEntryNotFound);
            }
            return this.watchRepository(ctx, repository, lastKnownRevision, normalizedPath, timeOutMillis, errorOnEntryNotFound);
        }
        Revision normalizedRev = repository.normalizeNow(new Revision(revision));
        if (query != null) {
            return repository.get(normalizedRev, query).handle(HttpApiUtil.returnOrThrow(result -> DtoConverter.convert(repository, normalizedRev, result, true)));
        }
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, normalizedRev, true, future);
        return future;
    }

    private CompletableFuture<?> watchFile(ServiceRequestContext ctx, Repository repository, Revision lastKnownRevision, Query<?> query, long timeOutMillis, boolean errorOnEntryNotFound) {
        CompletableFuture<Entry<?>> future = this.watchService.watchFile(repository, lastKnownRevision, query, timeOutMillis, errorOnEntryNotFound);
        if (!future.isDone()) {
            ctx.log().whenComplete().thenRun(() -> future.cancel(false));
        }
        return ((CompletableFuture)future.thenApply(entry -> {
            Revision revision = entry.revision();
            EntryDto entryDto = DtoConverter.convert(repository, revision, entry, true);
            return new WatchResultDto(revision, entryDto);
        })).exceptionally(ContentServiceV1::handleWatchFailure);
    }

    private CompletableFuture<?> watchRepository(ServiceRequestContext ctx, Repository repository, Revision lastKnownRevision, String pathPattern, long timeOutMillis, boolean errorOnEntryNotFound) {
        CompletableFuture<Revision> future = this.watchService.watchRepository(repository, lastKnownRevision, pathPattern, timeOutMillis, errorOnEntryNotFound);
        if (!future.isDone()) {
            ctx.log().whenComplete().thenRun(() -> future.cancel(false));
        }
        return ((CompletableFuture)future.thenApply(revision -> new WatchResultDto(revision, null))).exceptionally(ContentServiceV1::handleWatchFailure);
    }

    private static Object handleWatchFailure(Throwable thrown) {
        Throwable rootCause = Throwables.getRootCause((Throwable)thrown);
        if (rootCause instanceof CancellationException || rootCause instanceof ShuttingDownException) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_MODIFIED);
        }
        return Exceptions.throwUnsafely((Throwable)thrown);
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/commits(?<revision>(|/.*))$")
    public CompletableFuture<?> listCommits(ServiceRequestContext ctx, @Param String revision, @Param @Default(value="/**") String path, @Param @Nullable String to, @Param @Nullable Integer maxCommits, Repository repository) {
        Revision toRevision;
        Revision fromRevision;
        if (Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision)) {
            fromRevision = Revision.HEAD;
            toRevision = to != null ? new Revision(to) : Revision.INIT;
        } else {
            fromRevision = new Revision(revision.substring(1));
            toRevision = to != null ? new Revision(to) : fromRevision;
        }
        RevisionRange range = repository.normalizeNow(fromRevision, toRevision).toDescending();
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, range.from());
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, range.to());
        int maxCommits0 = (Integer)MoreObjects.firstNonNull((Object)maxCommits, (Object)100);
        return repository.history(range.from(), range.to(), ContentServiceV1.normalizePath(path), maxCommits0).thenApply(commits -> {
            boolean toList = to != null || Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision);
            return ContentServiceV1.objectOrList(commits, toList, DtoConverter::convert);
        });
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/compare")
    public CompletableFuture<?> getDiff(ServiceRequestContext ctx, @Param @Default(value="/**") String pathPattern, @Param @Default(value="1") String from, @Param @Default(value="head") String to, Repository repository, @RequestConverter(value=QueryRequestConverter.class) @Nullable Query<?> query) {
        Revision fromRevision = new Revision(from);
        Revision toRevision = new Revision(to);
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, fromRevision);
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, toRevision);
        if (query != null) {
            return repository.diff(fromRevision, toRevision, query).thenApply(DtoConverter::convert);
        }
        return repository.diff(fromRevision, toRevision, ContentServiceV1.normalizePath(pathPattern)).thenApply(changeMap -> (ImmutableList)changeMap.values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    private static <T> Object objectOrList(Collection<T> collection, boolean toList, Function<T, ?> converter) {
        if (collection.isEmpty()) {
            return ImmutableList.of();
        }
        if (toList) {
            return collection.stream().map(converter).collect(ImmutableList.toImmutableList());
        }
        return converter.apply(Iterables.getOnlyElement(collection));
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/merge")
    public <T> CompletableFuture<MergedEntryDto<T>> mergeFiles(ServiceRequestContext ctx, @Param @Default(value="-1") String revision, Repository repository, @RequestConverter(value=MergeQueryRequestConverter.class) MergeQuery<T> query) {
        Revision rev = new Revision(revision);
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, rev);
        return repository.mergeFiles(rev, query).thenApply(DtoConverter::convert);
    }

    public static void checkPush(String repoName, Iterable<Change<?>> changes, boolean isAdmin) {
        if ("meta".equals(repoName)) {
            boolean hasChangesOtherThanMetaRepoFiles = Streams.stream(changes).anyMatch(change -> !DefaultMetaRepository.isMetaFile(change.path()));
            if (hasChangesOtherThanMetaRepoFiles) {
                throw new InvalidPushException("The meta repository is reserved for internal usage.");
            }
            if (!isAdmin) {
                for (Change<?> change2 : changes) {
                    String path = change2.path();
                    if (change2.type() == ChangeType.REMOVE) continue;
                    if ("/mirrors.json".equals(path)) {
                        throw new InvalidPushException("'/mirrors.json' file is not allowed to create. Use '/mirrors/{id}.json' file or '/api/v1/projects/{projectName}/mirrors' API instead.");
                    }
                    if (!"/credentials.json".equals(path)) continue;
                    throw new InvalidPushException("'/credentials.json' file is not allowed to create. Use '/credentials/{id}.json' file or '/api/v1/projects/{projectName}/credentials' API instead.");
                }
            }
            Optional<String> notAllowedLocalRepo = Streams.stream(changes).filter(change -> DefaultMetaRepository.isMirrorFile(change.path())).filter(change -> change.content() != null).map(change -> {
                Object content = change.content();
                if (content instanceof JsonNode) {
                    String localRepo;
                    JsonNode node = (JsonNode)content;
                    if (!node.isObject()) {
                        return null;
                    }
                    JsonNode localRepoNode = node.get(MIRROR_LOCAL_REPO);
                    if (localRepoNode != null && Project.isReservedRepoName(localRepo = localRepoNode.textValue())) {
                        return localRepo;
                    }
                }
                return null;
            }).filter(Objects::nonNull).findFirst();
            if (notAllowedLocalRepo.isPresent()) {
                throw new InvalidPushException("invalid localRepo: " + notAllowedLocalRepo.get());
            }
        }
    }
}

