/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.UpdateServerStatusRequest;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresAdministrator;
import com.linecorp.centraldogma.server.management.ServerStatus;
import com.linecorp.centraldogma.server.management.ServerStatusManager;
import java.util.concurrent.CompletableFuture;

@ProducesJson
public final class AdministrativeService
extends AbstractService {
    private final ServerStatusManager serverStatusManager;

    public AdministrativeService(CommandExecutor executor, ServerStatusManager serverStatusManager) {
        super(executor);
        this.serverStatusManager = serverStatusManager;
    }

    @Get(value="/status")
    public ServerStatus status() {
        return ServerStatus.of(this.executor().isWritable(), this.executor().isStarted());
    }

    @Put(value="/status")
    @Consumes(value="application/json")
    @RequiresAdministrator
    public CompletableFuture<ServerStatus> updateStatus(UpdateServerStatusRequest statusRequest) throws Exception {
        ServerStatus oldStatus = this.status();
        ServerStatus newStatus = statusRequest.serverStatus();
        if (statusRequest.scope() == UpdateServerStatusRequest.Scope.LOCAL) {
            if (oldStatus == newStatus) {
                throw HttpStatusException.of((HttpStatus)HttpStatus.NOT_MODIFIED);
            }
            return CompletableFuture.supplyAsync(() -> {
                this.executor().statusManager().updateStatus(newStatus);
                this.serverStatusManager.updateStatus(newStatus);
                return this.status();
            }, this.serverStatusManager.sequentialExecutor());
        }
        return this.execute(Command.updateServerStatus(newStatus)).thenApply(unused -> this.status());
    }
}

