/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.project;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ReadOnlyException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.storage.project.Project;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class InternalProjectInitializer {
    public static final String INTERNAL_PROJECT_DOGMA = "dogma";
    private final CommandExecutor executor;
    private final CompletableFuture<Void> initialFuture = new CompletableFuture();

    public InternalProjectInitializer(CommandExecutor executor) {
        this.executor = executor;
    }

    public void initialize() {
        try {
            this.initialize0();
            this.initialFuture.complete(null);
        }
        catch (Exception cause) {
            this.initialFuture.completeExceptionally(cause);
        }
    }

    public void initialize0() {
        Throwable peeled;
        long creationTimeMillis;
        block6: {
            creationTimeMillis = System.currentTimeMillis();
            try {
                this.executor.execute(Command.createProject(creationTimeMillis, Author.SYSTEM, INTERNAL_PROJECT_DOGMA)).get();
            }
            catch (Throwable cause) {
                peeled = Exceptions.peel((Throwable)cause);
                if (peeled instanceof ReadOnlyException) {
                    return;
                }
                if (peeled instanceof ProjectExistsException) break block6;
                throw new Error("failed to initialize an internal project: dogma", peeled);
            }
        }
        this.initializeInternalRepos(Project.internalRepos(), creationTimeMillis);
        try {
            Change change = Change.ofJsonPatch((String)"/tokens.json", null, (JsonNode)Jackson.valueToTree((Object)new Tokens()));
            String commitSummary = "Initialize the token list file: /dogma/dogma/tokens.json";
            this.executor.execute(Command.push(Author.SYSTEM, INTERNAL_PROJECT_DOGMA, INTERNAL_PROJECT_DOGMA, Revision.HEAD, "Initialize the token list file: /dogma/dogma/tokens.json", "", Markup.PLAINTEXT, ImmutableList.of((Object)change))).get();
        }
        catch (Throwable cause) {
            peeled = Exceptions.peel((Throwable)cause);
            if (peeled instanceof ReadOnlyException || peeled instanceof ChangeConflictException) {
                return;
            }
            throw new Error("failed to initialize the token list file", peeled);
        }
    }

    public CompletableFuture<Void> whenInitialized() {
        return this.initialFuture;
    }

    public void initializeInternalRepos(List<String> internalRepos) {
        Objects.requireNonNull(internalRepos, "internalRepos");
        long creationTimeMillis = System.currentTimeMillis();
        this.initializeInternalRepos(internalRepos, creationTimeMillis);
    }

    private void initializeInternalRepos(List<String> internalRepos, long creationTimeMillis) {
        for (String repo : internalRepos) {
            try {
                this.executor.execute(Command.createRepository(creationTimeMillis, Author.SYSTEM, INTERNAL_PROJECT_DOGMA, repo)).get();
            }
            catch (Throwable cause) {
                Throwable peeled = Exceptions.peel((Throwable)cause);
                if (peeled instanceof ReadOnlyException) {
                    return;
                }
                if (peeled instanceof RepositoryExistsException) continue;
                throw new Error("failed to initialize an internal repository: dogma/" + repo, peeled);
            }
        }
    }
}

