/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.api.v1.MirrorDto;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronField;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronFieldName;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.internal.storage.repository.MirrorConfig;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryWrapper;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.mirror.MirrorUtil;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.jgit.lib.Repository;

public final class DefaultMetaRepository
extends RepositoryWrapper
implements MetaRepository {
    public static final String PATH_CREDENTIALS = "/credentials/";
    public static final String PATH_MIRRORS = "/mirrors/";

    public static boolean isMetaFile(String path) {
        return "/mirrors.json".equals(path) || "/credentials.json".equals(path) || path.endsWith(".json") && (path.startsWith(PATH_CREDENTIALS) || path.startsWith(PATH_MIRRORS));
    }

    public static boolean isMirrorFile(String path) {
        return path.endsWith(".json") && (path.startsWith(PATH_CREDENTIALS) || path.startsWith(PATH_MIRRORS));
    }

    public static String credentialFile(String credentialId) {
        return PATH_CREDENTIALS + credentialId + ".json";
    }

    public static String mirrorFile(String mirrorId) {
        return PATH_MIRRORS + mirrorId + ".json";
    }

    public DefaultMetaRepository(com.linecorp.centraldogma.server.storage.repository.Repository repo) {
        super(repo);
    }

    @Override
    public Repository jGitRepository() {
        return this.unwrap().jGitRepository();
    }

    @Override
    public CompletableFuture<List<Mirror>> mirrors(boolean includeDisabled) {
        if (includeDisabled) {
            return this.allMirrors();
        }
        return this.allMirrors().thenApply(mirrors -> (List)mirrors.stream().filter(Mirror::enabled).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public CompletableFuture<Mirror> mirror(String id) {
        String mirrorFile = DefaultMetaRepository.mirrorFile(id);
        return this.find(mirrorFile).thenCompose(entries -> {
            MirrorConfig c;
            Entry entry = (Entry)entries.get(mirrorFile);
            if (entry == null) {
                throw new EntryNotFoundException("failed to find credential '" + mirrorFile + "' in " + this.parent().name() + '/' + this.name());
            }
            JsonNode mirrorJson = (JsonNode)entry.content();
            if (!mirrorJson.isObject()) {
                throw this.newInvalidJsonTypeException(mirrorFile, mirrorJson);
            }
            try {
                c = (MirrorConfig)Jackson.treeToValue((TreeNode)mirrorJson, MirrorConfig.class);
            }
            catch (JsonProcessingException e) {
                throw new RepositoryMetadataException("failed to load the mirror configuration", e);
            }
            CompletionStage<List<MirrorCredential>> credentials = Strings.isNullOrEmpty((String)c.credentialId()) ? this.credentials() : this.credential(c.credentialId()).thenApply(ImmutableList::of);
            return credentials.thenApply(credentials0 -> {
                Mirror mirror = c.toMirror(this.parent(), (Iterable<MirrorCredential>)credentials0);
                if (mirror == null) {
                    throw new EntryNotFoundException("failed to find a mirror config for '" + mirrorFile + "' in " + this.parent().name() + '/' + this.name());
                }
                return mirror;
            });
        });
    }

    private CompletableFuture<List<Mirror>> allMirrors() {
        return this.find("/mirrors/*.json").thenCompose(entries -> {
            if (entries.isEmpty()) {
                return UnmodifiableFuture.completedFuture((Object)ImmutableList.of());
            }
            return this.credentials().thenApply(credentials -> {
                try {
                    return this.parseMirrors((Map<String, Entry<?>>)entries, (List<MirrorCredential>)credentials);
                }
                catch (JsonProcessingException e) {
                    return (List)Exceptions.throwUnsafely((Throwable)e);
                }
            });
        });
    }

    private List<Mirror> parseMirrors(Map<String, Entry<?>> entries, List<MirrorCredential> credentials) throws JsonProcessingException {
        return (List)entries.entrySet().stream().map(entry -> {
            MirrorConfig c;
            JsonNode mirrorJson = (JsonNode)((Entry)entry.getValue()).content();
            if (!mirrorJson.isObject()) {
                throw this.newInvalidJsonTypeException((String)entry.getKey(), mirrorJson);
            }
            try {
                c = (MirrorConfig)Jackson.treeToValue((TreeNode)mirrorJson, MirrorConfig.class);
            }
            catch (JsonProcessingException e) {
                return (Mirror)Exceptions.throwUnsafely((Throwable)e);
            }
            return c.toMirror(this.parent(), credentials);
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Override
    public CompletableFuture<List<MirrorCredential>> credentials() {
        return this.find("/credentials/*.json").thenApply(entries -> {
            if (entries.isEmpty()) {
                return ImmutableList.of();
            }
            try {
                return this.parseCredentials((Map<String, Entry<?>>)entries);
            }
            catch (Exception e) {
                throw new RepositoryMetadataException("failed to load the credential configuration", e);
            }
        });
    }

    @Override
    public CompletableFuture<MirrorCredential> credential(String credentialId) {
        String credentialFile = DefaultMetaRepository.credentialFile(credentialId);
        return this.find(credentialFile).thenApply(entries -> {
            Entry entry = (Entry)entries.get(credentialFile);
            if (entry == null) {
                throw new EntryNotFoundException("failed to find credential '" + credentialId + "' in " + this.parent().name() + '/' + this.name());
            }
            try {
                return this.parseCredential(credentialFile, (Entry<JsonNode>)entry);
            }
            catch (Exception e) {
                throw new RepositoryMetadataException("failed to load the credential configuration", e);
            }
        });
    }

    private List<MirrorCredential> parseCredentials(Map<String, Entry<?>> entries) throws JsonProcessingException {
        return (List)entries.entrySet().stream().map(entry -> {
            try {
                return this.parseCredential((String)entry.getKey(), (Entry<JsonNode>)((Entry)entry.getValue()));
            }
            catch (JsonProcessingException e) {
                return (MirrorCredential)Exceptions.throwUnsafely((Throwable)e);
            }
        }).collect(ImmutableList.toImmutableList());
    }

    private MirrorCredential parseCredential(String credentialFile, Entry<JsonNode> entry) throws JsonProcessingException {
        JsonNode credentialJson = (JsonNode)entry.content();
        if (!credentialJson.isObject()) {
            throw this.newInvalidJsonTypeException(credentialFile, credentialJson);
        }
        return (MirrorCredential)Jackson.treeToValue((TreeNode)credentialJson, MirrorCredential.class);
    }

    private RepositoryMetadataException newInvalidJsonTypeException(String fileName, JsonNode credentialJson) {
        return new RepositoryMetadataException(this.parent().name() + '/' + this.name() + fileName + " must be an object: " + credentialJson.getNodeType());
    }

    private CompletableFuture<Map<String, Entry<?>>> find(String filePattern) {
        return this.find(Revision.HEAD, filePattern, (Map<FindOption<?>, ?>)ImmutableMap.of());
    }

    @Override
    public CompletableFuture<Command<CommitResult>> createPushCommand(MirrorDto mirrorDto, Author author, boolean update) {
        DefaultMetaRepository.validateMirror(mirrorDto);
        if (update) {
            String summary = "Update the mirror '" + mirrorDto.id() + '\'';
            return this.mirror(mirrorDto.id()).thenApply(mirror -> this.newCommand(mirrorDto, author, summary));
        }
        String summary = "Create a new mirror from " + mirrorDto.remoteUrl() + mirrorDto.remotePath() + '#' + mirrorDto.remoteBranch() + " into " + mirrorDto.localRepo() + mirrorDto.localPath();
        summary = MirrorDirection.valueOf(mirrorDto.direction()) == MirrorDirection.REMOTE_TO_LOCAL ? "[Remote-to-local] " + summary : "[Local-to-remote] " + summary;
        return UnmodifiableFuture.completedFuture(this.newCommand(mirrorDto, author, summary));
    }

    @Override
    public CompletableFuture<Command<CommitResult>> createPushCommand(MirrorCredential credential, Author author, boolean update) {
        Preconditions.checkArgument((!credential.id().isEmpty() ? 1 : 0) != 0, (Object)"Credential ID should not be empty");
        if (update) {
            return this.credential(credential.id()).thenApply(c -> {
                assert (c.id().equals(credential.id()));
                String summary = "Update the mirror credential '" + credential.id() + '\'';
                return this.newCommand(credential, author, summary);
            });
        }
        String summary = "Create a new mirror credential for " + credential.id();
        return UnmodifiableFuture.completedFuture(this.newCommand(credential, author, summary));
    }

    private Command<CommitResult> newCommand(MirrorDto mirrorDto, Author author, String summary) {
        MirrorConfig mirrorConfig = DefaultMetaRepository.converterToMirrorConfig(mirrorDto);
        JsonNode jsonNode = Jackson.valueToTree((Object)mirrorConfig);
        Change change = Change.ofJsonUpsert((String)DefaultMetaRepository.mirrorFile(mirrorConfig.id()), (JsonNode)jsonNode);
        return Command.push(author, this.parent().name(), this.name(), Revision.HEAD, summary, "", Markup.PLAINTEXT, change);
    }

    private Command<CommitResult> newCommand(MirrorCredential credential, Author author, String summary) {
        JsonNode jsonNode = Jackson.valueToTree((Object)credential);
        Change change = Change.ofJsonUpsert((String)DefaultMetaRepository.credentialFile(credential.id()), (JsonNode)jsonNode);
        return Command.push(author, this.parent().name(), this.name(), Revision.HEAD, summary, "", Markup.PLAINTEXT, change);
    }

    private static void validateMirror(MirrorDto mirror) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mirror.id()) ? 1 : 0) != 0, (Object)"Mirror ID is empty");
        Cron schedule = MirrorConfig.CRON_PARSER.parse(mirror.schedule());
        CronField secondField = schedule.retrieve(CronFieldName.SECOND);
        Preconditions.checkArgument((!secondField.getExpression().asString().contains("*") ? 1 : 0) != 0, (Object)"The second field of the schedule must be specified. (seconds: *, expected: 0-59)");
    }

    private static MirrorConfig converterToMirrorConfig(MirrorDto mirrorDto) {
        String remoteUri = mirrorDto.remoteScheme() + "://" + mirrorDto.remoteUrl() + MirrorUtil.normalizePath(mirrorDto.remotePath()) + '#' + mirrorDto.remoteBranch();
        return new MirrorConfig(mirrorDto.id(), mirrorDto.enabled(), mirrorDto.schedule(), MirrorDirection.valueOf(mirrorDto.direction()), mirrorDto.localRepo(), mirrorDto.localPath(), URI.create(remoteUri), mirrorDto.gitignore(), mirrorDto.credentialId());
    }
}

