/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class CacheableCall<T> {
    private static final Lock[] locks = new Lock[8192];
    final Repository repo;

    protected CacheableCall(Repository repo) {
        this.repo = Objects.requireNonNull(repo, "repo");
    }

    public final Repository repo() {
        return this.repo;
    }

    public final Lock coarseGrainedLock() {
        return locks[Math.abs(this.hashCode() % locks.length)];
    }

    protected abstract int weigh(T var1);

    public abstract CompletableFuture<T> execute();

    public int hashCode() {
        return System.identityHashCode(this.repo);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheableCall that = (CacheableCall)obj;
        return this.repo == that.repo;
    }

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("repo", (Object)(this.repo.parent().name() + '/' + this.repo.name()));
        this.toString(helper);
        return helper.toString();
    }

    protected abstract void toString(MoreObjects.ToStringHelper var1);

    static {
        for (int i = 0; i < locks.length; ++i) {
            CacheableCall.locks[i] = new ReentrantLock();
        }
    }
}

