/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.internal.shaded.guava.base.CharMatcher;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Splitter;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.internal.mirror.credential.AbstractMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredentialUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublicKeyMirrorCredential
extends AbstractMirrorCredential {
    private static final Logger logger = LoggerFactory.getLogger(PublicKeyMirrorCredential.class);
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\n\r")).omitEmptyStrings().trimResults();
    private static final int PUBLIC_KEY_PREVIEW_LEN = 40;
    private final String username;
    private final String publicKey;
    private final String privateKey;
    @Nullable
    private final String passphrase;

    @JsonCreator
    public PublicKeyMirrorCredential(@JsonProperty(value="id") String id, @JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="hostnamePatterns") @Nullable @JsonDeserialize(contentAs=Pattern.class) Iterable<Pattern> hostnamePatterns, @JsonProperty(value="username") String username, @JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="privateKey") String privateKey, @JsonProperty(value="passphrase") @Nullable String passphrase) {
        super(id, enabled, "public_key", hostnamePatterns);
        this.username = MirrorCredentialUtil.requireNonEmpty(username, "username");
        this.publicKey = MirrorCredentialUtil.requireNonEmpty(publicKey, "publicKey");
        this.privateKey = MirrorCredentialUtil.requireNonEmpty(privateKey, "privateKey");
        this.passphrase = passphrase;
    }

    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @JsonProperty(value="publicKey")
    public String publicKey() {
        return this.publicKey;
    }

    public List<String> privateKey() {
        String converted;
        try {
            converted = CentralDogmaConfig.convertValue(this.privateKey, "credentials.privateKey");
        }
        catch (Throwable t) {
            logger.debug("Failed to convert the key of the credential. username: {}, id: {}", new Object[]{this.username, this.id(), t});
            converted = this.privateKey;
        }
        assert (converted != null);
        return ImmutableList.copyOf((Collection)NEWLINE_SPLITTER.splitToList((CharSequence)converted));
    }

    @JsonProperty(value="privateKey")
    public String rawPrivateKey() {
        return this.privateKey;
    }

    @Nullable
    public String passphrase() {
        try {
            return CentralDogmaConfig.convertValue(this.passphrase, "credentials.passphrase");
        }
        catch (Throwable t) {
            logger.debug("Failed to convert the passphrase of the credential. username: {}, id: {}", new Object[]{this.username, this.id(), t});
            return this.passphrase;
        }
    }

    @JsonProperty(value="passphrase")
    @Nullable
    public String rawPassphrase() {
        return this.passphrase;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicKeyMirrorCredential)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublicKeyMirrorCredential that = (PublicKeyMirrorCredential)o;
        return this.username.equals(that.username) && Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.privateKey, that.privateKey) && Objects.equals(this.passphrase, that.passphrase);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.username, this.publicKey, this.privateKey, this.passphrase);
    }

    @Override
    void addProperties(MoreObjects.ToStringHelper helper) {
        helper.add("username", (Object)this.username).add("publicKey", (Object)PublicKeyMirrorCredential.publicKeyPreview(this.publicKey));
    }

    public static String publicKeyPreview(String publicKey) {
        if (publicKey.length() > 40) {
            return publicKey.substring(0, 40) + "..";
        }
        return publicKey;
    }
}

