/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.internal.mirror.credential.AbstractMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredentialUtil;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessTokenMirrorCredential
extends AbstractMirrorCredential {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenMirrorCredential.class);
    private final String accessToken;

    @JsonCreator
    public AccessTokenMirrorCredential(@JsonProperty(value="id") String id, @JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="hostnamePatterns") @Nullable @JsonDeserialize(contentAs=Pattern.class) Iterable<Pattern> hostnamePatterns, @JsonProperty(value="accessToken") String accessToken) {
        super(id, enabled, "access_token", hostnamePatterns);
        this.accessToken = MirrorCredentialUtil.requireNonEmpty(accessToken, "accessToken");
    }

    public String accessToken() {
        try {
            return CentralDogmaConfig.convertValue(this.accessToken, "credentials.accessToken");
        }
        catch (Throwable t) {
            logger.debug("Failed to convert the access token of the credential: {}", (Object)this.id(), (Object)t);
            return this.accessToken;
        }
    }

    @JsonProperty(value="accessToken")
    public String rawAccessToken() {
        return this.accessToken;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.accessToken.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessTokenMirrorCredential)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessTokenMirrorCredential that = (AccessTokenMirrorCredential)o;
        return this.accessToken.equals(that.accessToken);
    }

    @Override
    void addProperties(MoreObjects.ToStringHelper helper) {
    }
}

