/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.api.v1.MirrorDto;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ProducesJson
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class MirroringServiceV1
extends AbstractService {
    private final ProjectApiManager projectApiManager;

    public MirroringServiceV1(ProjectApiManager projectApiManager, CommandExecutor executor) {
        super(executor);
        this.projectApiManager = projectApiManager;
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/mirrors")
    public CompletableFuture<List<MirrorDto>> listMirrors(@Param String projectName) {
        return this.metaRepo(projectName).mirrors(true).thenApply(mirrors -> (List)mirrors.stream().map(mirror -> MirroringServiceV1.convertToMirrorDto(projectName, mirror)).collect(ImmutableList.toImmutableList()));
    }

    @RequiresReadPermission(repository="meta")
    @Get(value="/projects/{projectName}/mirrors/{id}")
    public CompletableFuture<MirrorDto> getMirror(@Param String projectName, @Param String id) {
        return this.metaRepo(projectName).mirror(id).thenApply(mirror -> MirroringServiceV1.convertToMirrorDto(projectName, mirror));
    }

    @RequiresWritePermission(repository="meta")
    @Post(value="/projects/{projectName}/mirrors")
    @ConsumesJson
    @StatusCode(value=201)
    public CompletableFuture<PushResultDto> createMirror(@Param String projectName, MirrorDto newMirror, Author author) {
        return this.createOrUpdate(projectName, newMirror, author, false);
    }

    @RequiresWritePermission(repository="meta")
    @Put(value="/projects/{projectName}/mirrors")
    @ConsumesJson
    public CompletableFuture<PushResultDto> updateMirror(@Param String projectName, MirrorDto mirror, Author author) {
        return this.createOrUpdate(projectName, mirror, author, true);
    }

    private CompletableFuture<PushResultDto> createOrUpdate(String projectName, MirrorDto newMirror, Author author, boolean update) {
        return this.metaRepo(projectName).createPushCommand(newMirror, author, update).thenCompose(command -> this.executor().execute(command).thenApply(result -> new PushResultDto(result.revision(), command.timestamp())));
    }

    private static MirrorDto convertToMirrorDto(String projectName, Mirror mirror) {
        URI remoteRepoUri = mirror.remoteRepoUri();
        return new MirrorDto(mirror.id(), Boolean.valueOf(mirror.enabled()), projectName, mirror.schedule().asString(), mirror.direction().name(), mirror.localRepo().name(), mirror.localPath(), remoteRepoUri.getScheme(), remoteRepoUri.getHost() + remoteRepoUri.getPath(), mirror.remotePath(), mirror.remoteBranch(), mirror.gitignore(), mirror.credential().id());
    }

    private MetaRepository metaRepo(String projectName) {
        return this.projectApiManager.getProject(projectName).metaRepo();
    }
}

