/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.linecorp.armeria.common.util.StartStopSupport;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import com.linecorp.centraldogma.server.storage.project.InternalProjectInitializer;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PluginGroup {
    private static final Logger logger = LoggerFactory.getLogger(PluginGroup.class);
    private final List<Plugin> plugins;
    private final PluginGroupStartStop startStop;

    @Nullable
    static PluginGroup loadPlugins(PluginTarget target, CentralDogmaConfig config) {
        return PluginGroup.loadPlugins(PluginGroup.class.getClassLoader(), target, config);
    }

    @Nullable
    static PluginGroup loadPlugins(ClassLoader classLoader, PluginTarget target, CentralDogmaConfig config) {
        Objects.requireNonNull(classLoader, "classLoader");
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(config, "config");
        ServiceLoader<Plugin> loader = ServiceLoader.load(Plugin.class, classLoader);
        ImmutableMap.Builder plugins = new ImmutableMap.Builder();
        for (Plugin plugin : loader) {
            if (target != plugin.target() || !plugin.isEnabled(config)) continue;
            plugins.put(plugin.configType(), (Object)plugin);
        }
        ImmutableMap pluginMap = plugins.build();
        if (pluginMap.isEmpty()) {
            return null;
        }
        return new PluginGroup(pluginMap.values(), Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("plugins-for-" + target.name().toLowerCase().replace("_", "-"), true)));
    }

    private PluginGroup(Iterable<Plugin> plugins, Executor executor) {
        this.plugins = ImmutableList.copyOf(Objects.requireNonNull(plugins, "plugins"));
        this.startStop = new PluginGroupStartStop(Objects.requireNonNull(executor, "executor"));
    }

    List<Plugin> plugins() {
        return this.plugins;
    }

    <T extends Plugin> Optional<T> findFirstPlugin(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.plugins.stream().filter(clazz::isInstance).map(clazz::cast).findFirst();
    }

    CompletableFuture<Void> start(CentralDogmaConfig config, ProjectManager projectManager, CommandExecutor commandExecutor, MeterRegistry meterRegistry, ScheduledExecutorService purgeWorker, InternalProjectInitializer internalProjectInitializer) {
        PluginContext context = new PluginContext(config, projectManager, commandExecutor, meterRegistry, purgeWorker, internalProjectInitializer);
        return this.startStop.start(context, context, true);
    }

    CompletableFuture<Void> stop(CentralDogmaConfig config, ProjectManager projectManager, CommandExecutor commandExecutor, MeterRegistry meterRegistry, ScheduledExecutorService purgeWorker, InternalProjectInitializer internalProjectInitializer) {
        return this.startStop.stop(new PluginContext(config, projectManager, commandExecutor, meterRegistry, purgeWorker, internalProjectInitializer));
    }

    private class PluginGroupStartStop
    extends StartStopSupport<PluginContext, PluginContext, Void, Void> {
        PluginGroupStartStop(Executor executor) {
            super(executor);
        }

        protected CompletionStage<Void> doStart(@Nullable PluginContext arg) throws Exception {
            assert (arg != null);
            arg.internalProjectInitializer().whenInitialized().get();
            List futures = (List)PluginGroup.this.plugins.stream().map(plugin -> plugin.start(arg).thenAccept(unused -> logger.info("Plugin started: {}", plugin)).exceptionally(cause -> {
                logger.info("Failed to start plugin: {}", plugin, cause);
                return null;
            })).collect(ImmutableList.toImmutableList());
            return CompletableFutures.allAsList((List)futures).thenApply(unused -> null);
        }

        protected CompletionStage<Void> doStop(@Nullable PluginContext arg) throws Exception {
            assert (arg != null);
            List futures = (List)PluginGroup.this.plugins.stream().map(plugin -> plugin.stop(arg).thenAccept(unused -> logger.info("Plugin stopped: {}", plugin)).exceptionally(cause -> {
                logger.info("Failed to stop plugin: {}", plugin, cause);
                return null;
            })).collect(ImmutableList.toImmutableList());
            return CompletableFutures.allAsList((List)futures).thenApply(unused -> null);
        }
    }
}

