/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CachingRepositoryManager;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryManager;
import com.linecorp.centraldogma.server.metadata.Member;
import com.linecorp.centraldogma.server.metadata.PerRolePermissions;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.ProjectRole;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProject
implements Project {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProject.class);
    private final String name;
    private final long creationTimeMillis;
    private final Author author;
    final RepositoryManager repos;
    private final AtomicReference<MetaRepository> metaRepo = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultProject(File rootDir, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache) {
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        if (!rootDir.exists()) {
            throw new ProjectNotFoundException(rootDir.toString());
        }
        this.name = rootDir.getName();
        this.repos = this.newRepoManager(rootDir, repositoryWorker, purgeWorker, cache);
        boolean success = false;
        try {
            this.createReservedRepos(System.currentTimeMillis());
            UserAndTimestamp creation = this.metadataCreation();
            if (creation != null) {
                this.creationTimeMillis = creation.timestampMillis();
                this.author = Author.ofEmail((String)creation.user());
            } else {
                this.creationTimeMillis = ((Repository)this.repos.get("dogma")).creationTimeMillis();
                this.author = ((Repository)this.repos.get("dogma")).author();
            }
            success = true;
        }
        finally {
            if (!success) {
                this.repos.close(() -> new CentralDogmaException("failed to initialize internal repositories"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultProject(File rootDir, Executor repositoryWorker, Executor purgeWorker, long creationTimeMillis, Author author, @Nullable RepositoryCache cache) {
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        if (rootDir.exists()) {
            throw new ProjectExistsException(rootDir.getName());
        }
        this.name = rootDir.getName();
        this.repos = this.newRepoManager(rootDir, repositoryWorker, purgeWorker, cache);
        boolean success = false;
        try {
            this.createReservedRepos(creationTimeMillis);
            this.initializeMetadata(creationTimeMillis, author);
            this.creationTimeMillis = creationTimeMillis;
            this.author = author;
            success = true;
        }
        finally {
            if (!success) {
                this.repos.close(() -> new CentralDogmaException("failed to initialize internal repositories"));
            }
        }
    }

    @Nullable
    private UserAndTimestamp metadataCreation() {
        if (this.name.equals("dogma")) {
            return null;
        }
        Entry metadata = ((Repository)this.repos.get("dogma")).get(Revision.HEAD, Query.ofJson((String)"/metadata.json")).join();
        try {
            return ((ProjectMetadata)Jackson.treeToValue((TreeNode)((TreeNode)metadata.content()), ProjectMetadata.class)).creation();
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.warn("Failed to retrieve creation in {} file. project: {}", (Object)"/metadata.json", (Object)this.name);
            return null;
        }
    }

    private RepositoryManager newRepoManager(File rootDir, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache) {
        GitRepositoryManager gitRepos = new GitRepositoryManager(this, rootDir, repositoryWorker, purgeWorker, cache);
        return cache == null ? gitRepos : new CachingRepositoryManager((RepositoryManager)gitRepos, cache);
    }

    private void createReservedRepos(long creationTimeMillis) {
        if (!this.repos.exists("dogma")) {
            try {
                this.repos.create("dogma", creationTimeMillis, Author.SYSTEM);
            }
            catch (RepositoryExistsException repositoryExistsException) {
                // empty catch block
            }
        }
        if (!this.repos.exists("meta")) {
            try {
                this.repos.create("meta", creationTimeMillis, Author.SYSTEM);
            }
            catch (RepositoryExistsException repositoryExistsException) {
                // empty catch block
            }
        }
    }

    private void initializeMetadata(long creationTimeMillis, Author author) {
        Revision headRev;
        if (this.name.equals("dogma")) {
            return;
        }
        Repository dogmaRepo = (Repository)this.repos.get("dogma");
        if (!dogmaRepo.exists(headRev = dogmaRepo.normalizeNow(Revision.HEAD), "/metadata.json").join().booleanValue()) {
            logger.info("Initializing metadata: {}", (Object)this.name);
            UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
            RepositoryMetadata repo = new RepositoryMetadata("meta", userAndTimestamp, PerRolePermissions.ofInternal());
            Member member = new Member(author, ProjectRole.OWNER, userAndTimestamp);
            ProjectMetadata metadata = new ProjectMetadata(this.name, (Map<String, RepositoryMetadata>)ImmutableMap.of((Object)repo.id(), (Object)repo), (Map<String, Member>)ImmutableMap.of((Object)member.id(), (Object)member), (Map<String, TokenRegistration>)ImmutableMap.of(), userAndTimestamp, null);
            dogmaRepo.commit(headRev, creationTimeMillis, Author.SYSTEM, "Initialize metadata", "", Markup.PLAINTEXT, Change.ofJsonUpsert((String)"/metadata.json", (JsonNode)Jackson.valueToTree((Object)metadata))).join();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long creationTimeMillis() {
        return this.creationTimeMillis;
    }

    @Override
    public Author author() {
        return this.author;
    }

    @Override
    public MetaRepository metaRepo() {
        MetaRepository metaRepo = this.metaRepo.get();
        if (metaRepo != null) {
            return metaRepo;
        }
        metaRepo = new DefaultMetaRepository((Repository)this.repos.get("meta"));
        if (this.metaRepo.compareAndSet(null, metaRepo)) {
            return metaRepo;
        }
        return this.metaRepo.get();
    }

    @Override
    public RepositoryManager repos() {
        return this.repos;
    }

    public String toString() {
        return Util.simpleTypeName(this.getClass()) + '(' + this.repos + ')';
    }
}

