/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.github.benmanes.caffeine.cache.Cache;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.ForwardingSessionManager;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class CachedSessionManager
extends ForwardingSessionManager {
    private final Cache<String, Session> cache;

    public CachedSessionManager(SessionManager delegate, Cache<String, Session> cache) {
        super(delegate);
        this.cache = Objects.requireNonNull(cache, "cache");
    }

    @Override
    public CompletableFuture<Boolean> exists(String sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        if (this.cache.getIfPresent((Object)sessionId) != null) {
            return CompletableFuture.completedFuture(true);
        }
        return super.exists(sessionId);
    }

    @Override
    public CompletableFuture<Session> get(String sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        Session session = (Session)this.cache.getIfPresent((Object)sessionId);
        if (session != null) {
            return CompletableFuture.completedFuture(session);
        }
        return super.get(sessionId).thenApply(found -> {
            if (found != null) {
                this.cache.put((Object)sessionId, found);
            }
            return found;
        });
    }

    @Override
    public CompletableFuture<Void> create(Session session) {
        return super.create(session).thenApply(unused -> {
            this.cache.put((Object)session.id(), (Object)session);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> update(Session session) {
        return super.update(session).thenApply(unused -> {
            this.cache.put((Object)session.id(), (Object)session);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> delete(String sessionId) {
        return super.delete(sessionId).thenApply(unused -> {
            this.cache.invalidate((Object)sessionId);
            return null;
        });
    }
}

