/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.storage.project.Project;
import java.util.List;

public final class ProjectInitializer {
    public static final String INTERNAL_PROJECT_DOGMA = "dogma";

    public static void initializeInternalProject(CommandExecutor executor) {
        block2: {
            long creationTimeMillis = System.currentTimeMillis();
            ProjectInitializer.initializeInternalProject(executor, creationTimeMillis, INTERNAL_PROJECT_DOGMA);
            ProjectInitializer.initializeInternalRepos(executor, creationTimeMillis, Project.internalRepos());
            try {
                Change change = Change.ofJsonPatch((String)"/tokens.json", null, (JsonNode)Jackson.valueToTree((Object)new Tokens()));
                String commitSummary = "Initialize the token list file: /dogma/dogma/tokens.json";
                executor.execute(Command.push(Author.SYSTEM, INTERNAL_PROJECT_DOGMA, INTERNAL_PROJECT_DOGMA, Revision.HEAD, "Initialize the token list file: /dogma/dogma/tokens.json", "", Markup.PLAINTEXT, ImmutableList.of((Object)change))).get();
            }
            catch (Throwable cause) {
                Throwable peeled = Exceptions.peel((Throwable)cause);
                if (peeled instanceof ChangeConflictException) break block2;
                throw new Error("failed to initialize the token list file", peeled);
            }
        }
    }

    public static void initializeInternalProject(CommandExecutor executor, long creationTimeMillis, String projectName) {
        block2: {
            try {
                executor.execute(Command.createProject(creationTimeMillis, Author.SYSTEM, projectName)).get();
            }
            catch (Throwable cause) {
                Throwable peeled = Exceptions.peel((Throwable)cause);
                if (peeled instanceof ProjectExistsException) break block2;
                throw new Error("failed to initialize an internal project: " + projectName, peeled);
            }
        }
    }

    public static void initializeInternalRepos(CommandExecutor executor, long creationTimeMillis, List<String> internalRepos) {
        for (String repo : internalRepos) {
            try {
                executor.execute(Command.createRepository(creationTimeMillis, Author.SYSTEM, INTERNAL_PROJECT_DOGMA, repo)).get();
            }
            catch (Throwable cause) {
                Throwable peeled = Exceptions.peel((Throwable)cause);
                if (peeled instanceof RepositoryExistsException) continue;
                throw new Error("failed to initialize an internal repository: dogma/" + repo, peeled);
            }
        }
    }

    private ProjectInitializer() {
    }
}

