/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.core.TreeNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.metadata.HolderWithRevision;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

final class RepositorySupport<T> {
    private final ProjectManager projectManager;
    private final CommandExecutor executor;
    private final Function<Entry<?>, T> entryConverter;

    RepositorySupport(ProjectManager projectManager, CommandExecutor executor, Function<Entry<?>, T> entryConverter) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.entryConverter = Objects.requireNonNull(entryConverter, "entryConverter");
    }

    public ProjectManager projectManager() {
        return this.projectManager;
    }

    CompletableFuture<HolderWithRevision<T>> fetch(String projectName, String repoName, String path) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        return this.fetch((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName), path);
    }

    CompletableFuture<HolderWithRevision<T>> fetch(String projectName, String repoName, String path, Revision revision) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(revision, "revision");
        return this.fetch((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName), path, revision);
    }

    private CompletableFuture<HolderWithRevision<T>> fetch(Repository repository, String path) {
        Objects.requireNonNull(path, "path");
        Revision revision = this.normalize(repository);
        return this.fetch(repository, path, revision);
    }

    private CompletableFuture<HolderWithRevision<T>> fetch(Repository repository, String path, Revision revision) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(revision, "revision");
        return ((CompletableFuture)repository.get(revision, path).thenApply(this.entryConverter)).thenApply(obj -> HolderWithRevision.of(obj, revision));
    }

    CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, Change<?> change) {
        return this.push(projectName, repoName, author, commitSummary, change, Revision.HEAD);
    }

    private CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, Change<?> change, Revision revision) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(commitSummary, "commitSummary");
        Objects.requireNonNull(change, "change");
        return this.executor.execute(Command.push(author, projectName, repoName, revision, commitSummary, "", Markup.PLAINTEXT, ImmutableList.of(change))).thenApply(CommitResult::revision);
    }

    CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, Supplier<CompletionStage<HolderWithRevision<Change<?>>>> changeSupplier) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(commitSummary, "commitSummary");
        Objects.requireNonNull(changeSupplier, "changeSupplier");
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        this.push(projectName, repoName, author, commitSummary, changeSupplier, future);
        return future;
    }

    private void push(String projectName, String repoName, Author author, String commitSummary, Supplier<CompletionStage<HolderWithRevision<Change<?>>>> changeSupplier, CompletableFuture<Revision> future) {
        changeSupplier.get().thenAccept(changeWithRevision -> {
            Revision revision = changeWithRevision.revision();
            Change change = (Change)changeWithRevision.object();
            ((CompletableFuture)this.push(projectName, repoName, author, commitSummary, change, revision).thenAccept(future::complete)).exceptionally(Functions.voidFunction(arg_0 -> this.lambda$push$1(projectName, repoName, future, revision, author, commitSummary, (Supplier)changeSupplier, arg_0)));
        }).exceptionally(Functions.voidFunction(future::completeExceptionally));
    }

    Revision normalize(Repository repository) {
        Objects.requireNonNull(repository, "repository");
        try {
            return repository.normalizeNow(Revision.HEAD);
        }
        catch (Throwable cause) {
            return (Revision)Exceptions.throwUnsafely((Throwable)cause);
        }
    }

    static <T> T convertWithJackson(Entry<?> entry, Class<T> clazz) {
        Objects.requireNonNull(entry, "entry");
        Objects.requireNonNull(clazz, "clazz");
        try {
            return (T)Jackson.treeToValue((TreeNode)((TreeNode)entry.content()), clazz);
        }
        catch (Throwable cause) {
            return (T)Exceptions.throwUnsafely((Throwable)cause);
        }
    }

    private /* synthetic */ void lambda$push$1(String projectName, String repoName, CompletableFuture future, Revision revision, Author author, String commitSummary, Supplier changeSupplier, Throwable cause) {
        if ((cause = Exceptions.peel((Throwable)cause)) instanceof ChangeConflictException) {
            Revision latestRevision;
            try {
                latestRevision = ((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).normalizeNow(Revision.HEAD);
            }
            catch (Throwable cause1) {
                future.completeExceptionally(cause1);
                return;
            }
            if (revision.equals((Object)latestRevision)) {
                future.completeExceptionally(cause);
                return;
            }
            this.push(projectName, repoName, author, commitSummary, changeSupplier, future);
        } else if (cause instanceof RedundantChangeException) {
            future.complete(revision);
        } else {
            future.completeExceptionally(cause);
        }
    }
}

