/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.server.internal.storage.RequestAlreadyTimedOutException;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepository;
import javax.annotation.Nullable;
import org.slf4j.Logger;

final class FailFastUtil {
    private static final RequestAlreadyTimedOutException REQUEST_ALREADY_TIMED_OUT = (RequestAlreadyTimedOutException)Exceptions.clearTrace((Throwable)new RequestAlreadyTimedOutException("Request already timed out."));

    @Nullable
    static ServiceRequestContext context() {
        return (ServiceRequestContext)RequestContext.mapCurrent(ServiceRequestContext.class::cast, null);
    }

    static void failFastIfTimedOut(GitRepository repo, Logger logger, @Nullable ServiceRequestContext ctx, String methodName, Object arg1) {
        if (ctx != null && ctx.isTimedOut()) {
            logger.info("{} Rejecting a request timed out already: repo={}/{}, method={}, args={}", new Object[]{ctx, repo.parent().name(), repo.name(), methodName, arg1});
            throw REQUEST_ALREADY_TIMED_OUT;
        }
    }

    static void failFastIfTimedOut(GitRepository repo, Logger logger, @Nullable ServiceRequestContext ctx, String methodName, Object arg1, Object arg2) {
        if (ctx != null && ctx.isTimedOut()) {
            logger.info("{} Rejecting a request timed out already: repo={}/{}, method={}, args=[{}, {}]", new Object[]{ctx, repo.parent().name(), repo.name(), methodName, arg1, arg2});
            throw REQUEST_ALREADY_TIMED_OUT;
        }
    }

    static void failFastIfTimedOut(GitRepository repo, Logger logger, @Nullable ServiceRequestContext ctx, String methodName, Object arg1, Object arg2, Object arg3) {
        if (ctx != null && ctx.isTimedOut()) {
            logger.info("{} Rejecting a request timed out already: repo={}/{}, method={}, args=[{}, {}, {}]", new Object[]{ctx, repo.parent().name(), repo.name(), methodName, arg1, arg2, arg3});
            throw REQUEST_ALREADY_TIMED_OUT;
        }
    }

    static void failFastIfTimedOut(GitRepository repo, Logger logger, @Nullable ServiceRequestContext ctx, String methodName, Object arg1, Object arg2, Object arg3, int arg4) {
        if (ctx != null && ctx.isTimedOut()) {
            logger.info("{} Rejecting a request timed out already: repo={}/{}, method={}, args=[{}, {}, {}, {}]", new Object[]{ctx, repo.parent().name(), repo.name(), methodName, arg1, arg2, arg3, arg4});
            throw REQUEST_ALREADY_TIMED_OUT;
        }
    }

    private FailFastUtil() {
    }

    static {
        REQUEST_ALREADY_TIMED_OUT.initCause(null);
    }
}

