/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.ForcePushCommand;
import com.linecorp.centraldogma.server.command.NormalizingPushCommand;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ReplicationLog<T> {
    private final int replicaId;
    private final Command<T> command;
    private final T result;

    @JsonCreator
    static <T> ReplicationLog<T> deserialize(@JsonProperty(value="replicaId") @Nullable Integer replicaId, @JsonProperty(value="command") Command<T> command, @JsonProperty(value="result") JsonNode result) throws JsonProcessingException {
        return new ReplicationLog<T>(Objects.requireNonNull(replicaId, "replicaId"), command, ReplicationLog.deserializeResult(result, command));
    }

    @Nullable
    private static <T> T deserializeResult(JsonNode result, Command<T> command) throws JsonProcessingException {
        Class resultType;
        Objects.requireNonNull(command, "command");
        if (result != null && result.isNull()) {
            result = null;
        }
        if ((resultType = command.type() == CommandType.FORCE_PUSH ? (Class)Util.unsafeCast(((ForcePushCommand)command).delegate().type().resultType()) : (Class)Util.unsafeCast(command.type().resultType())) == Void.class) {
            if (result != null) {
                ReplicationLog.rejectIncompatibleResult(result, Void.class);
            }
            return null;
        }
        assert (result != null);
        return (T)Jackson.treeToValue((TreeNode)result, (Class)resultType);
    }

    ReplicationLog(int replicaId, Command<T> command, @Nullable T result) {
        this.replicaId = replicaId;
        assert (!(command instanceof NormalizingPushCommand)) : NormalizingPushCommand.class.getSimpleName() + " cannot be replicated.";
        this.command = Objects.requireNonNull(command, "command");
        Class<?> resultType = command.type() == CommandType.FORCE_PUSH ? ((ForcePushCommand)command).delegate().type().resultType() : command.type().resultType();
        if (resultType == Void.class) {
            if (result != null) {
                ReplicationLog.rejectIncompatibleResult(result, Void.class);
            }
        } else {
            Objects.requireNonNull(result, "result");
            if (!resultType.isInstance(result)) {
                ReplicationLog.rejectIncompatibleResult(result, resultType);
            }
        }
        this.result = result;
    }

    private static void rejectIncompatibleResult(Object result, Class<?> resultType) {
        throw new IllegalArgumentException("incompatible result: " + result + " (expected type: " + resultType.getName() + ')');
    }

    @JsonProperty
    public int replicaId() {
        return this.replicaId;
    }

    @JsonProperty
    public Command<T> command() {
        return this.command;
    }

    @JsonProperty
    public T result() {
        return this.result;
    }

    public int hashCode() {
        return this.replicaId() * 31 + this.command().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReplicationLog)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ReplicationLog that = (ReplicationLog)obj;
        return this.replicaId() == that.replicaId() && Objects.equals(this.result(), that.result()) && this.command().equals(that.command());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("(replicaId: ");
        buf.append(this.replicaId());
        buf.append(", command: ");
        buf.append(this.command());
        buf.append(", result: ");
        buf.append(this.result());
        buf.append(')');
        return buf.toString();
    }
}

