/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandType;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class AbstractCommand<T>
implements Command<T> {
    private final CommandType type;
    private final long timestamp;
    private final Author author;

    protected AbstractCommand(CommandType type, @Nullable Long timestamp, @Nullable Author author) {
        this.type = Objects.requireNonNull(type, "type");
        this.timestamp = timestamp != null ? timestamp : System.currentTimeMillis();
        this.author = author != null ? author : Author.SYSTEM;
    }

    @Override
    public final CommandType type() {
        return this.type;
    }

    @Override
    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    public final Author author() {
        return this.author;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractCommand)) {
            return false;
        }
        AbstractCommand that = (AbstractCommand)obj;
        return this.type == that.type && this.timestamp == that.timestamp && this.author.equals((Object)that.author);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.timestamp, this.author});
    }

    public final String toString() {
        return this.toStringHelper().toString();
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("timestamp", this.timestamp).add("author", (Object)this.author);
    }
}

