/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.centraldogma.server.internal.mirror.CentralDogmaMirror;
import com.linecorp.centraldogma.server.internal.storage.repository.MirrorUtil;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorContext;
import com.linecorp.centraldogma.server.mirror.MirrorProvider;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CentralDogmaMirrorProvider
implements MirrorProvider {
    private static final Pattern DOGMA_PATH_PATTERN = Pattern.compile("^/([^/]+)/([^/]+)\\.dogma$");

    @Override
    public Mirror newMirror(MirrorContext context) {
        Objects.requireNonNull(context, "context");
        URI remoteUri = context.remoteUri();
        String scheme = remoteUri.getScheme();
        if (scheme == null) {
            return null;
        }
        if (!"dogma".equals(scheme)) {
            return null;
        }
        String[] components = MirrorUtil.split(remoteUri, "dogma");
        URI remoteRepoUri = URI.create(components[0]);
        Matcher matcher = DOGMA_PATH_PATTERN.matcher(remoteRepoUri.getPath());
        if (!matcher.find()) {
            throw new IllegalArgumentException("cannot determine project name and repository name: " + remoteUri + " (expected: dogma://<host>[:<port>]/<project>/<repository>.dogma[<remotePath>])");
        }
        String remoteProject = matcher.group(1);
        String remoteRepo = matcher.group(2);
        return new CentralDogmaMirror(context.schedule(), context.direction(), context.credential(), context.localRepo(), context.localPath(), remoteRepoUri, remoteProject, remoteRepo, components[1], context.gitignore());
    }
}

