/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.function.Function;

public final class MetadataServiceInjector
extends SimpleDecoratingHttpService {
    private static final AttributeKey<MetadataService> METADATA_SERVICE_ATTRIBUTE_KEY = AttributeKey.valueOf(MetadataServiceInjector.class, (String)"METADATA");
    private final MetadataService mds;

    public static Function<? super HttpService, MetadataServiceInjector> newDecorator(MetadataService mds) {
        Objects.requireNonNull(mds, "mds");
        return service -> new MetadataServiceInjector((HttpService)service, mds);
    }

    private MetadataServiceInjector(HttpService delegate, MetadataService mds) {
        super(delegate);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        ctx.setAttr(METADATA_SERVICE_ATTRIBUTE_KEY, (Object)this.mds);
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
    }

    public static MetadataService getMetadataService(ServiceRequestContext ctx) {
        MetadataService mds = (MetadataService)ctx.attr(METADATA_SERVICE_ATTRIBUTE_KEY);
        if (mds != null) {
            return mds;
        }
        throw new IllegalStateException("No metadata service instance exists.");
    }
}

