/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.internal.mirror.DefaultMirroringService;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public final class DefaultMirroringServicePlugin
implements Plugin {
    @Nullable
    private volatile DefaultMirroringService mirroringService;

    @Override
    public PluginTarget target() {
        return PluginTarget.LEADER_ONLY;
    }

    @Override
    public synchronized CompletionStage<Void> start(PluginContext context) {
        Objects.requireNonNull(context, "context");
        DefaultMirroringService mirroringService = this.mirroringService;
        if (mirroringService == null) {
            CentralDogmaConfig cfg = context.config();
            this.mirroringService = mirroringService = new DefaultMirroringService(new File(cfg.dataDir(), "_mirrors"), context.projectManager(), context.meterRegistry(), cfg.numMirroringThreads(), cfg.maxNumFilesPerMirror(), cfg.maxNumBytesPerMirror());
        }
        mirroringService.start(context.commandExecutor());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletionStage<Void> stop(PluginContext context) {
        DefaultMirroringService mirroringService = this.mirroringService;
        if (mirroringService != null && mirroringService.isStarted()) {
            mirroringService.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isEnabled(CentralDogmaConfig config) {
        return Objects.requireNonNull(config, "config").isMirroringEnabled();
    }

    @Nullable
    public DefaultMirroringService mirroringService() {
        return this.mirroringService;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target()).toString();
    }
}

