/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import javax.annotation.Nullable;

public final class HttpApiRequestConverter
implements RequestConverterFunction {
    private final ProjectManager projectManager;

    public HttpApiRequestConverter(ProjectManager projectManager) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
    }

    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        if (expectedResultType == Project.class) {
            String projectName = ctx.pathParam("projectName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"project name should not be null or empty.");
            return this.projectManager.get(projectName);
        }
        if (expectedResultType == Repository.class) {
            String projectName = ctx.pathParam("projectName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"project name should not be null or empty.");
            String repositoryName = ctx.pathParam("repoName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repositoryName) ? 1 : 0) != 0, (Object)"repository name should not be null or empty.");
            if ("dogma".equals(repositoryName) && !AuthUtil.currentUser(ctx).isAdmin()) {
                return HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "Repository '%s/%s' can be accessed only by an administrator.", projectName, "dogma");
            }
            return ((Project)this.projectManager.get(projectName)).repos().get(repositoryName);
        }
        if (expectedResultType == Author.class) {
            return AuthUtil.currentAuthor(ctx);
        }
        if (expectedResultType == User.class) {
            return AuthUtil.currentUser(ctx);
        }
        return RequestConverterFunction.fallthrough();
    }
}

