/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.command.AbstractCommand;
import com.linecorp.centraldogma.server.command.CommandType;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class ProjectCommand<T>
extends AbstractCommand<T> {
    private final String projectName;

    ProjectCommand(CommandType commandType, @Nullable Long timestamp, @Nullable Author author, String projectName) {
        super(commandType, timestamp, author);
        this.projectName = Objects.requireNonNull(projectName, "projectName");
    }

    @JsonProperty
    public final String projectName() {
        return this.projectName;
    }

    @Override
    public String executionPath() {
        return '/' + this.projectName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectCommand)) {
            return false;
        }
        ProjectCommand that = (ProjectCommand)obj;
        return super.equals(obj) && this.projectName.equals(that.projectName);
    }

    @Override
    public int hashCode() {
        return this.projectName.hashCode() * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("projectName", (Object)this.projectName);
    }
}

