/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.repository;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class RepositoryUtil {
    private static final CancellationException CANCELLATION_EXCEPTION = (CancellationException)Exceptions.clearTrace((Throwable)new CancellationException("parent complete"));

    static CompletableFuture<MergedEntry<?>> mergeEntries(List<CompletableFuture<Entry<?>>> entryFutures, Revision revision, MergeQuery<?> query) {
        Objects.requireNonNull(entryFutures, "entryFutures");
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        CompletableFuture future = new CompletableFuture();
        CompletableFutures.allAsList(entryFutures).handle((entries, cause) -> {
            JsonNode result;
            if (cause != null) {
                future.completeExceptionally(Exceptions.peel((Throwable)cause));
                return null;
            }
            ImmutableList.Builder jsonNodesBuilder = ImmutableList.builder();
            ImmutableList.Builder pathsBuilder = ImmutableList.builder();
            for (Entry entry : entries) {
                if (entry == null) continue;
                try {
                    jsonNodesBuilder.add((Object)entry.contentAsJson());
                    pathsBuilder.add((Object)entry.path());
                }
                catch (JsonParseException e) {
                    future.completeExceptionally(e);
                    return null;
                }
            }
            try {
                ImmutableList jsonNodes = jsonNodesBuilder.build();
                if (jsonNodes.isEmpty()) {
                    throw new EntryNotFoundException(revision, RepositoryUtil.concatenatePaths(query.mergeSources()));
                }
                result = Jackson.mergeTree((Iterable)jsonNodes);
                List expressions = query.expressions();
                if (!Iterables.isEmpty((Iterable)expressions)) {
                    result = Jackson.extractTree((JsonNode)result, (Iterable)expressions);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                return null;
            }
            future.complete(MergedEntry.of((Revision)revision, (EntryType)EntryType.JSON, (Object)result, (Iterable)pathsBuilder.build()));
            return null;
        });
        return (CompletableFuture)Util.unsafeCast(future);
    }

    private static String concatenatePaths(Iterable<MergeSource> mergeSources) {
        return Streams.stream(mergeSources).map(MergeSource::path).collect(Collectors.joining(","));
    }

    static <T> Entry<T> applyQuery(Entry<T> entry, Query<T> query) {
        Objects.requireNonNull(query, "query");
        entry.content();
        EntryType entryType = entry.type();
        QueryType queryType = query.type();
        if (!queryType.supportedEntryTypes().contains(entryType)) {
            throw new QueryExecutionException("Unsupported entry type: " + entryType + " (query: " + query + ')');
        }
        if (queryType == QueryType.IDENTITY || queryType == QueryType.IDENTITY_TEXT || queryType == QueryType.IDENTITY_JSON) {
            return entry;
        }
        if (queryType == QueryType.JSON_PATH) {
            return Entry.of((Revision)entry.revision(), (String)query.path(), (EntryType)entryType, (Object)query.apply(entry.content()));
        }
        throw new QueryExecutionException("Unsupported entry type: " + entryType + " (query: " + query + ')');
    }

    static <T> CompletableFuture<Entry<T>> watch(Repository repo, Revision lastKnownRev, Query<T> query, boolean errorOnEntryNotFound) {
        Objects.requireNonNull(repo, "repo");
        Objects.requireNonNull(lastKnownRev, "lastKnownRev");
        Objects.requireNonNull(query, "query");
        Query castQuery = (Query)Util.unsafeCast(query);
        CompletableFuture parentFuture = new CompletableFuture();
        ((CompletableFuture)repo.getOrNull(lastKnownRev, castQuery).thenAccept(oldResult -> RepositoryUtil.watch(repo, (Query<Object>)castQuery, lastKnownRev, (Entry<Object>)oldResult, parentFuture, errorOnEntryNotFound))).exceptionally(Functions.voidFunction(parentFuture::completeExceptionally));
        return (CompletableFuture)Util.unsafeCast(parentFuture);
    }

    private static void watch(Repository repo, Query<Object> query, Revision lastKnownRev, @Nullable Entry<Object> oldResult, CompletableFuture<Entry<Object>> parentFuture, boolean errorOnEntryNotFound) {
        CompletableFuture<Revision> future = repo.watch(lastKnownRev, query.path(), errorOnEntryNotFound);
        parentFuture.whenComplete((res, cause) -> future.completeExceptionally(CANCELLATION_EXCEPTION));
        ((CompletableFuture)future.thenCompose(newRev -> repo.getOrNull((Revision)newRev, query).thenAccept(newResult -> {
            if (errorOnEntryNotFound && newResult == null) {
                parentFuture.completeExceptionally((Throwable)new EntryNotFoundException(newRev, query.path()));
                return;
            }
            if (newResult == null || oldResult != null && Objects.equals(oldResult.content(), newResult.content())) {
                if (!parentFuture.isDone()) {
                    RepositoryUtil.watch(repo, query, newRev, oldResult, parentFuture, errorOnEntryNotFound);
                }
            } else {
                parentFuture.complete((Entry<Object>)newResult);
            }
        }))).exceptionally(Functions.voidFunction(parentFuture::completeExceptionally));
    }

    private RepositoryUtil() {
    }
}

