/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.mirror;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MirrorUtil {
    static final Pattern DOGMA_PATH_PATTERN = Pattern.compile("^/([^/]+)/([^/]+)\\.dogma$");

    public static String normalizePath(String path) {
        Objects.requireNonNull(path, "path");
        if (path.isEmpty()) {
            return "/";
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.endsWith("/")) {
            path = path + '/';
        }
        return path.replaceAll("//+", "/");
    }

    static String[] split(URI remoteUri, String suffix) {
        String remotePath;
        String host = remoteUri.getHost();
        if (host == null && !remoteUri.getScheme().endsWith("+file")) {
            throw new IllegalArgumentException("no host in remoteUri: " + remoteUri);
        }
        String path = remoteUri.getRawPath();
        if (path == null) {
            throw new IllegalArgumentException("no path in remoteUri: " + remoteUri);
        }
        Matcher matcher = Pattern.compile("^(.*?\\." + suffix + ")(?:$|/)").matcher(path);
        if (!matcher.find()) {
            throw new IllegalArgumentException("no '." + suffix + "' in remoteUri path: " + remoteUri);
        }
        int port = remoteUri.getPort();
        String newRemoteUri = host != null ? (port > 0 ? remoteUri.getScheme() + "://" + host + ':' + port + matcher.group(1) : remoteUri.getScheme() + "://" + host + matcher.group(1)) : remoteUri.getScheme() + "://" + matcher.group(1);
        try {
            String decoded = URLDecoder.decode(path.substring(matcher.group(1).length()), "UTF-8");
            remotePath = decoded = MirrorUtil.normalizePath(decoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        String remoteBranch = remoteUri.getFragment();
        return new String[]{newRemoteUri, remotePath, remoteBranch};
    }

    private MirrorUtil() {
    }
}

