/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.CronType;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.definition.CronDefinitionBuilder;
import com.linecorp.centraldogma.internal.shaded.cronutils.parser.CronParser;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryWrapper;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class DefaultMetaRepository
extends RepositoryWrapper
implements MetaRepository {
    public static final String PATH_CREDENTIALS = "/credentials.json";
    public static final String PATH_MIRRORS = "/mirrors.json";
    public static final Set<String> metaRepoFiles = ImmutableSet.of((Object)"/credentials.json", (Object)"/mirrors.json");
    private static final String PATH_CREDENTIALS_AND_MIRRORS = "/credentials.json,/mirrors.json";
    private final Lock mirrorLock = new ReentrantLock();
    private int mirrorRev = -1;
    private Set<String> mirrorRepos = Collections.emptySet();
    private Set<Mirror> mirrors;

    public DefaultMetaRepository(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Mirror> mirrors() {
        this.mirrorLock.lock();
        try {
            int headRev = this.normalizeNow(Revision.HEAD).major();
            Set<String> repos = this.parent().repos().list().keySet();
            if (headRev > this.mirrorRev || !this.mirrorRepos.equals(repos)) {
                this.mirrors = this.loadMirrors(headRev);
                this.mirrorRev = headRev;
                this.mirrorRepos = repos;
            }
            Set<Mirror> set = this.mirrors;
            return set;
        }
        finally {
            this.mirrorLock.unlock();
        }
    }

    private Set<Mirror> loadMirrors(int rev) {
        Map<String, Entry<?>> entries = this.find(new Revision(rev), PATH_CREDENTIALS_AND_MIRRORS, Collections.emptyMap()).join();
        if (!entries.containsKey(PATH_MIRRORS)) {
            return Collections.emptySet();
        }
        JsonNode mirrorsJson = (JsonNode)entries.get(PATH_MIRRORS).content();
        if (!mirrorsJson.isArray()) {
            throw new RepositoryMetadataException("/mirrors.json must be an array: " + mirrorsJson.getNodeType());
        }
        if (mirrorsJson.size() == 0) {
            return Collections.emptySet();
        }
        try {
            List<MirrorCredential> credentials = DefaultMetaRepository.loadCredentials(entries);
            ImmutableSet.Builder mirrors = ImmutableSet.builder();
            for (JsonNode m : mirrorsJson) {
                MirrorConfig c = (MirrorConfig)Jackson.treeToValue((TreeNode)m, MirrorConfig.class);
                if (c == null) {
                    throw new RepositoryMetadataException("/mirrors.json contains null.");
                }
                mirrors.addAll(c.toMirrors(this.parent(), credentials));
            }
            return mirrors.build();
        }
        catch (RepositoryMetadataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryMetadataException("failed to load the mirror configuration", e);
        }
    }

    private static List<MirrorCredential> loadCredentials(Map<String, Entry<?>> entries) throws Exception {
        Entry<?> e = entries.get(PATH_CREDENTIALS);
        if (e == null) {
            return Collections.emptyList();
        }
        JsonNode credentialsJson = (JsonNode)e.content();
        if (!credentialsJson.isArray()) {
            throw new RepositoryMetadataException("/credentials.json must be an array: " + credentialsJson.getNodeType());
        }
        if (credentialsJson.size() == 0) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonNode c : credentialsJson) {
            MirrorCredential credential = (MirrorCredential)Jackson.treeToValue((TreeNode)c, MirrorCredential.class);
            if (credential == null) {
                throw new RepositoryMetadataException("/credentials.json contains null.");
            }
            builder.add((Object)credential);
        }
        return builder.build();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=SingleMirrorConfig.class, name="single"), @JsonSubTypes.Type(value=MultipleMirrorConfig.class, name="multiple")})
    private static abstract class MirrorConfig {
        static final String DEFAULT_SCHEDULE = "0 * * * * ?";
        static final CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        final boolean enabled;

        abstract List<Mirror> toMirrors(Project var1, Iterable<MirrorCredential> var2);

        static MirrorCredential findCredential(Iterable<MirrorCredential> credentials, URI remoteUri, @Nullable String credentialId) {
            if (credentialId != null) {
                for (MirrorCredential c : credentials) {
                    Optional<String> id = c.id();
                    if (!id.isPresent() || !credentialId.equals(id.get())) continue;
                    return c;
                }
            } else {
                for (MirrorCredential c : credentials) {
                    if (!c.matches(remoteUri)) continue;
                    return c;
                }
            }
            return MirrorCredential.FALLBACK;
        }

        MirrorConfig(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private static final class MirrorInclude {
        final Pattern pattern;
        final String replacement;
        @Nullable
        final MirrorDirection direction;
        @Nullable
        final String localPath;
        @Nullable
        final String credentialId;
        @Nullable
        final Cron schedule;

        @JsonCreator
        MirrorInclude(@JsonProperty(value="schedule") @Nullable String schedule, @JsonProperty(value="pattern", required=true) Pattern pattern, @JsonProperty(value="replacement", required=true) String replacement, @JsonProperty(value="direction") @Nullable MirrorDirection direction, @JsonProperty(value="localPath") @Nullable String localPath, @JsonProperty(value="credentialId") @Nullable String credentialId) {
            this.schedule = schedule != null ? MirrorConfig.cronParser.parse(schedule) : null;
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.replacement = Objects.requireNonNull(replacement, "replacement");
            this.direction = direction;
            this.localPath = localPath;
            this.credentialId = credentialId;
        }
    }

    private static final class MultipleMirrorConfig
    extends MirrorConfig {
        final MirrorDirection defaultDirection;
        final String defaultLocalPath;
        final Cron defaultSchedule;
        @Nullable
        final String defaultCredentialId;
        final List<MirrorInclude> includes;
        final List<Pattern> excludes;

        @JsonCreator
        MultipleMirrorConfig(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="defaultSchedule") @Nullable String defaultSchedule, @JsonProperty(value="defaultDirection", required=true) MirrorDirection defaultDirection, @JsonProperty(value="defaultLocalPath") @Nullable String defaultLocalPath, @JsonProperty(value="defaultCredentialId") @Nullable String defaultCredentialId, @JsonProperty(value="includes", required=true) @JsonDeserialize(contentAs=MirrorInclude.class) Iterable<MirrorInclude> includes, @JsonProperty(value="excludes") @Nullable @JsonDeserialize(contentAs=Pattern.class) Iterable<Pattern> excludes) {
            super((Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)true));
            this.defaultSchedule = cronParser.parse((String)MoreObjects.firstNonNull((Object)defaultSchedule, (Object)"0 * * * * ?"));
            this.defaultDirection = Objects.requireNonNull(defaultDirection, "defaultDirection");
            this.defaultLocalPath = (String)MoreObjects.firstNonNull((Object)defaultLocalPath, (Object)"/");
            this.defaultCredentialId = defaultCredentialId;
            this.includes = ImmutableList.copyOf((Iterable)Util.requireNonNullElements(includes, (String)"includes"));
            this.excludes = excludes != null ? ImmutableList.copyOf((Iterable)Util.requireNonNullElements(excludes, (String)"excludes")) : Collections.emptyList();
        }

        @Override
        List<Mirror> toMirrors(Project parent, Iterable<MirrorCredential> credentials) {
            if (!this.enabled) {
                return Collections.emptyList();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            parent.repos().list().forEach((repoName, repo) -> {
                if (repoName == null || this.excludes.stream().anyMatch(p -> p.matcher((CharSequence)repoName).find())) {
                    return;
                }
                for (MirrorInclude i : this.includes) {
                    Matcher m = i.pattern.matcher((CharSequence)repoName);
                    if (!m.matches()) continue;
                    URI remoteUri = URI.create(m.replaceFirst(i.replacement));
                    builder.add((Object)Mirror.of((Cron)MoreObjects.firstNonNull((Object)i.schedule, (Object)this.defaultSchedule), (MirrorDirection)((Object)((Object)MoreObjects.firstNonNull((Object)((Object)i.direction), (Object)((Object)this.defaultDirection)))), MultipleMirrorConfig.findCredential(credentials, remoteUri, i.credentialId != null ? i.credentialId : this.defaultCredentialId), repo, (String)MoreObjects.firstNonNull((Object)i.localPath, (Object)this.defaultLocalPath), remoteUri, null));
                }
            });
            return builder.build();
        }
    }

    private static final class SingleMirrorConfig
    extends MirrorConfig {
        final MirrorDirection direction;
        final String localRepo;
        final String localPath;
        final URI remoteUri;
        @Nullable
        final String gitignore;
        @Nullable
        final String credentialId;
        final Cron schedule;

        /*
         * Unable to fully structure code
         */
        @JsonCreator
        SingleMirrorConfig(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="schedule") @Nullable String schedule, @JsonProperty(value="direction", required=true) MirrorDirection direction, @JsonProperty(value="localRepo", required=true) String localRepo, @JsonProperty(value="localPath") @Nullable String localPath, @JsonProperty(value="remoteUri", required=true) URI remoteUri, @JsonProperty(value="gitignore") @Nullable Object gitignore, @JsonProperty(value="credentialId") @Nullable String credentialId) {
            super((Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)true));
            this.schedule = SingleMirrorConfig.cronParser.parse((String)MoreObjects.firstNonNull((Object)schedule, (Object)"0 * * * * ?"));
            this.direction = Objects.requireNonNull(direction, "direction");
            this.localRepo = Objects.requireNonNull(localRepo, "localRepo");
            this.localPath = (String)MoreObjects.firstNonNull((Object)localPath, (Object)"/");
            this.remoteUri = Objects.requireNonNull(remoteUri, "remoteUri");
            if (gitignore == null) ** GOTO lbl19
            if (!(gitignore instanceof Iterable)) ** GOTO lbl-1000
            if (Streams.stream((Iterable)((Iterable)gitignore)).allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(String.class))) {
                this.gitignore = String.join((CharSequence)"\n", (Iterable)gitignore);
            } else if (gitignore instanceof String) {
                this.gitignore = (String)gitignore;
            } else {
                throw new IllegalArgumentException("gitignore: " + gitignore + " (expected: either a string or an array of strings)");
lbl19:
                // 1 sources

                this.gitignore = null;
            }
            this.credentialId = credentialId;
        }

        @Override
        List<Mirror> toMirrors(Project parent, Iterable<MirrorCredential> credentials) {
            if (!this.enabled || this.localRepo == null || !parent.repos().exists(this.localRepo)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Mirror.of(this.schedule, this.direction, SingleMirrorConfig.findCredential(credentials, this.remoteUri, this.credentialId), (Repository)parent.repos().get(this.localRepo), this.localPath, this.remoteUri, this.gitignore));
        }
    }
}

