/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.mirror.credential.AbstractMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredentialUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class PublicKeyMirrorCredential
extends AbstractMirrorCredential {
    private static final int PUBLIC_KEY_PREVIEW_LEN = 40;
    private final String username;
    private final byte[] publicKey;
    private final byte[] privateKey;
    @Nullable
    private final byte[] passphrase;

    @JsonCreator
    public PublicKeyMirrorCredential(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="hostnamePatterns") @Nullable @JsonDeserialize(contentAs=Pattern.class) Iterable<Pattern> hostnamePatterns, @JsonProperty(value="username") String username, @JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="privateKey") String privateKey, @JsonProperty(value="passphrase") @Nullable String passphrase) {
        super(id, hostnamePatterns);
        this.username = MirrorCredentialUtil.requireNonEmpty(username, "username");
        MirrorCredentialUtil.requireNonEmpty(publicKey, "publicKey");
        MirrorCredentialUtil.requireNonEmpty(privateKey, "privateKey");
        this.publicKey = MirrorCredentialUtil.requireNonEmpty(publicKey, "publicKey").getBytes(StandardCharsets.UTF_8);
        this.privateKey = MirrorCredentialUtil.requireNonEmpty(privateKey, "privateKey").getBytes(StandardCharsets.UTF_8);
        this.passphrase = MirrorCredentialUtil.decodeBase64OrUtf8(passphrase, "passphrase");
    }

    public PublicKeyMirrorCredential(@Nullable String id, @Nullable Iterable<Pattern> hostnamePatterns, String username, byte[] publicKey, byte[] privateKey, @Nullable byte[] passphrase) {
        super(id, hostnamePatterns);
        this.username = MirrorCredentialUtil.requireNonEmpty(username, "username");
        this.publicKey = MirrorCredentialUtil.requireNonEmpty(publicKey, "publicKey");
        this.privateKey = MirrorCredentialUtil.requireNonEmpty(privateKey, "privateKey");
        this.passphrase = passphrase;
    }

    public String username() {
        return this.username;
    }

    public byte[] publicKey() {
        return (byte[])this.publicKey.clone();
    }

    public byte[] privateKey() {
        return (byte[])this.privateKey.clone();
    }

    @Nullable
    public byte[] passphrase() {
        if (this.passphrase == null) {
            return null;
        }
        return (byte[])this.passphrase.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicKeyMirrorCredential)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublicKeyMirrorCredential that = (PublicKeyMirrorCredential)o;
        return this.username.equals(that.username) && Arrays.equals(this.publicKey, that.publicKey) && Arrays.equals(this.privateKey, that.privateKey) && Arrays.equals(this.passphrase, that.passphrase);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + Arrays.hashCode(this.publicKey);
        result = 31 * result + Arrays.hashCode(this.privateKey);
        result = 31 * result + Arrays.hashCode(this.passphrase);
        return result;
    }

    @Override
    void addProperties(MoreObjects.ToStringHelper helper) {
        String publicKeyPreview = this.publicKey.length > 40 ? new String(this.publicKey, 0, 40, StandardCharsets.UTF_8) + ".." : new String(this.publicKey, StandardCharsets.UTF_8);
        helper.add("username", (Object)this.username).add("publicKey", (Object)publicKeyPreview);
    }
}

