/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;

public final class JGitUtil {
    public static final int REPO_FORMAT_VERSION = 1;
    private static final String REPO_FORMAT_VERSION_STR = String.valueOf(1);

    public static void applyDefaultsAndSave(StoredConfig config) throws IOException {
        if (JGitUtil.applyDefaults((Config)config)) {
            config.save();
        }
    }

    public static boolean applyDefaults(Config config) {
        boolean updated = false;
        updated |= JGitUtil.set(config, "core", "repositoryformatversion", REPO_FORMAT_VERSION_STR);
        updated |= JGitUtil.set(config, "core", "hidedotfiles", "false");
        updated |= JGitUtil.set(config, "core", "symlinks", "false");
        updated |= JGitUtil.set(config, "core", "filemode", "false");
        updated |= JGitUtil.set(config, "core", "logallrefupdates", "false");
        updated |= JGitUtil.set(config, "core", "precomposeunicode", "true");
        updated |= JGitUtil.set(config, "commit", "gpgSign", "false");
        updated |= JGitUtil.set(config, "diff", "algorithm", "histogram");
        updated |= JGitUtil.set(config, "diff", "renames", "false");
        updated |= JGitUtil.set(config, "gc", "auto", "0");
        updated |= JGitUtil.set(config, "gc", "autopacklimit", "0");
        return updated |= JGitUtil.set(config, "receive", "autogc", "false");
    }

    private static boolean set(Config config, String section, String name, String value) {
        Objects.requireNonNull(section, "section");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        String oldValue = config.getString(section, null, name);
        if (Objects.equals(oldValue, value)) {
            return false;
        }
        config.setString(section, null, name, value);
        return true;
    }

    private JGitUtil() {
    }
}

