/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.mirror;

import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.mirror.CentralDogmaMirror;
import com.linecorp.centraldogma.server.internal.mirror.GitMirror;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.mirror.MirrorUtil;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.File;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public interface Mirror {
    public static Mirror of(Cron schedule, MirrorDirection direction, MirrorCredential credential, Repository localRepo, String localPath, URI remoteUri, @Nullable String gitignore) {
        Objects.requireNonNull(schedule, "schedule");
        Objects.requireNonNull(direction, "direction");
        Objects.requireNonNull(credential, "credential");
        Objects.requireNonNull(localRepo, "localRepo");
        Objects.requireNonNull(localPath, "localPath");
        Objects.requireNonNull(remoteUri, "remoteUri");
        String scheme = remoteUri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("no scheme in remoteUri: " + remoteUri);
        }
        switch (scheme) {
            case "dogma": {
                String[] components = MirrorUtil.split(remoteUri, "dogma");
                URI remoteRepoUri = URI.create(components[0]);
                Matcher matcher = MirrorUtil.DOGMA_PATH_PATTERN.matcher(remoteRepoUri.getPath());
                if (!matcher.find()) {
                    throw new IllegalArgumentException("cannot determine project name and repository name: " + remoteUri + " (expected: dogma://<host>[:<port>]/<project>/<repository>.dogma[<remotePath>])");
                }
                String remoteProject = matcher.group(1);
                String remoteRepo = matcher.group(2);
                return new CentralDogmaMirror(schedule, direction, credential, localRepo, localPath, remoteRepoUri, remoteProject, remoteRepo, components[1], gitignore);
            }
            case "git": 
            case "git+ssh": 
            case "git+http": 
            case "git+https": 
            case "git+file": {
                String[] components = MirrorUtil.split(remoteUri, "git");
                return new GitMirror(schedule, direction, credential, localRepo, localPath, URI.create(components[0]), components[1], components[2], gitignore);
            }
        }
        throw new IllegalArgumentException("unsupported scheme in remoteUri: " + remoteUri);
    }

    public Cron schedule();

    public ZonedDateTime nextExecutionTime(ZonedDateTime var1);

    public MirrorDirection direction();

    public MirrorCredential credential();

    public Repository localRepo();

    public String localPath();

    public URI remoteRepoUri();

    public String remotePath();

    @Nullable
    public String remoteBranch();

    @Nullable
    public String gitignore();

    public void mirror(File var1, CommandExecutor var2, int var3, long var4);
}

